/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.dal.database;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import hu.documaison.data.entities.Comment;
import hu.documaison.data.entities.DefaultMetadata;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentTagConnection;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.entities.Tag;
import hu.documaison.settings.SettingsData;
import hu.documaison.settings.SettingsManager;
import java.sql.SQLException;

public class DatabaseUtils {
    private static String databaseUrl = "jdbc:sqlite:d:/temp/documaison.sqlite";
    private static final String databaseUrlTemplate = "jdbc:sqlite:%path%";
    private static final String ORMLITE_LOG_LEVEL = Log.Level.WARNING.name();

    static {
        DatabaseUtils.loadDatabasePath();
        System.setProperty("com.j256.ormlite.logger.level", ORMLITE_LOG_LEVEL);
    }

    private static void loadDatabasePath() {
        try {
            SettingsData settingsData = SettingsManager.getCurrentSettings();
            String path = settingsData.getDatabaseFileLocation().replace('\\', '/');
            databaseUrl = databaseUrlTemplate.replaceFirst("%path%", path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConnectionSource getConnectionSource() throws SQLException {
        JdbcConnectionSource connectionSource = new JdbcConnectionSource(databaseUrl);
        return connectionSource;
    }

    public static void createTables() throws SQLException {
        ConnectionSource connectionSource = DatabaseUtils.getConnectionSource();
        try {
            TableUtils.createTable(connectionSource, Tag.class);
            TableUtils.createTable(connectionSource, Comment.class);
            TableUtils.createTable(connectionSource, Metadata.class);
            TableUtils.createTable(connectionSource, DefaultMetadata.class);
            TableUtils.createTable(connectionSource, DocumentType.class);
            TableUtils.createTable(connectionSource, Document.class);
            TableUtils.createTable(connectionSource, DocumentTagConnection.class);
        }
        finally {
            connectionSource.close();
        }
    }

    public static void createTablesBestEffort() {
        DatabaseUtils.tryCreateTable(Tag.class);
        DatabaseUtils.tryCreateTable(Comment.class);
        DatabaseUtils.tryCreateTable(Metadata.class);
        DatabaseUtils.tryCreateTable(DefaultMetadata.class);
        DatabaseUtils.tryCreateTable(DocumentType.class);
        DatabaseUtils.tryCreateTable(Document.class);
        DatabaseUtils.tryCreateTable(DocumentTagConnection.class);
    }

    private static <T> void tryCreateTable(Class<T> tableClass) {
        ConnectionSource connectionSource = null;
        try {
            try {
                connectionSource = DatabaseUtils.getConnectionSource();
                TableUtils.createTable(connectionSource, tableClass);
            }
            catch (SQLException sQLException) {
                try {
                    if (connectionSource != null) {
                        connectionSource.close();
                    }
                }
                catch (SQLException sQLException2) {}
            }
        }
        finally {
            try {
                if (connectionSource != null) {
                    connectionSource.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

