/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.dal.interfaces;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import hu.documaison.dal.database.DatabaseUtils;
import hu.documaison.dal.interfaces.DalInterface;
import hu.documaison.data.entities.Comment;
import hu.documaison.data.entities.DatabaseObject;
import hu.documaison.data.entities.DefaultMetadata;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentTagConnection;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.entities.Tag;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.exceptions.UnknownDocumentTypeException;
import hu.documaison.data.exceptions.UnknownTagException;
import hu.documaison.data.helper.DataHelper;
import hu.documaison.data.helper.DocumentFilePointer;
import hu.documaison.data.helper.MetadataNameTypePair;
import hu.documaison.data.search.BoolOperator;
import hu.documaison.data.search.Expression;
import hu.documaison.data.search.SearchExpression;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

class DalImplementation
implements DalInterface {
    DalImplementation() {
    }

    private <T extends DatabaseObject> T genericCreate(Class<T> c, String info) {
        DatabaseObject instance;
        try {
            instance = (DatabaseObject)c.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return (T)this.genericCreate(c, instance, info);
    }

    private <T extends DatabaseObject> T genericCreate(Class<T> c, T instance, String info) {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, c);
            T ret = instance;
            dao.create(ret);
            T t = ret;
            return t;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, info);
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, info);
                }
            }
        }
        return null;
    }

    private <T extends DatabaseObject> void genericDelete(int id, Class<T> c, String info) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, c);
                    dao.deleteById(id);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, info);
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, info);
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, info);
                    }
                }
            }
        }
    }

    private <T extends DatabaseObject> void genericUpdate(T entity, Class<T> c, String info) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, c);
                    dao.update(entity);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, info);
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, info);
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, info);
                    }
                }
            }
        }
    }

    @Override
    public Comment createComment() throws UnableToCreateException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Comment.class);
            Comment comment = new Comment();
            dao.create((Comment)comment);
            Comment comment2 = comment;
            return comment2;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "createComment");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "createComment");
                }
            }
        }
        throw new UnableToCreateException("Comment");
    }

    @Override
    public DefaultMetadata createDefaultMetadata() throws UnableToCreateException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, DefaultMetadata.class);
            DefaultMetadata ret = new DefaultMetadata();
            dao.create((DefaultMetadata)ret);
            DefaultMetadata defaultMetadata = ret;
            return defaultMetadata;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "createDefaultMetadata");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "createDefaultMetadata");
                }
            }
        }
        throw new UnableToCreateException("DefaultMetadata");
    }

    @Override
    public Document createDocument(int typeId) throws UnknownDocumentTypeException, UnableToCreateException {
        ConnectionSource connectionSource = null;
        try {
            DocumentType documentType = this.getDocumentType(typeId);
            if (documentType == null) {
                throw new UnknownDocumentTypeException(typeId);
            }
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Document newDocument = new Document();
            newDocument.setType(documentType);
            dao.create((Document)newDocument);
            newDocument.setDateAdded(new Date());
            dao.update((Document)newDocument);
            Document document = newDocument;
            return document;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "createDocument");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "createDocument");
                }
            }
        }
        throw new UnableToCreateException("Document");
    }

    @Override
    public DocumentType createDocumentType() throws UnableToCreateException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
            DocumentType documentType = new DocumentType((Dao<DocumentType, Integer>)dao);
            dao.create((DocumentType)documentType);
            DocumentType documentType2 = documentType;
            return documentType2;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "createDocumentType");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "createDocumentType");
                }
            }
        }
        throw new UnableToCreateException("DocumentType");
    }

    @Override
    public Metadata createMetadata() throws UnableToCreateException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Metadata.class);
            Metadata ret = new Metadata();
            dao.create((Metadata)ret);
            Metadata metadata = ret;
            return metadata;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "createMetadata");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "createMetadata");
                }
            }
        }
        throw new UnableToCreateException("Metadata");
    }

    @Override
    public Tag createTag(String name) {
        return this.genericCreate(Tag.class, "createTag");
    }

    @Override
    public Document getDocument(int id) throws UnknownDocumentException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Document ret = (Document)dao.queryForId(id);
            if (ret == null) {
                throw new UnknownDocumentException(id);
            }
            Document document = ret;
            return document;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocument");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocument");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<Document> getDocuments() {
        ConnectionSource connectionSource = null;
        try {
            List<Document> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            List<Document> list = ret = dao.queryForAll();
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocuments");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocuments");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<Document> getDocumentsByTags(List<Tag> tags) {
        if (tags == null) {
            return new ArrayList<Document>();
        }
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        for (Tag t : tags) {
            tagIds.add(t.getId());
        }
        return this.getDocumentsByTagIds(tagIds);
    }

    @Override
    public Collection<Document> getDocumentsByTag(Tag tag) {
        return this.getDocumentsByTagId(tag.getId());
    }

    private Collection<Document> getDocumentsByTagId(int tagId) {
        ConnectionSource connectionSource = null;
        try {
            List<Document> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Object daoTags = DaoManager.createDao(connectionSource, DocumentTagConnection.class);
            QueryBuilder qb = dao.queryBuilder();
            QueryBuilder qbTags = daoTags.queryBuilder();
            qbTags.where().eq("tag", tagId);
            qb.join(qbTags);
            System.out.println("Query: " + qb.prepareStatementString());
            List<Document> list = ret = dao.query(qb.prepare());
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentsByTagId(int)");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentsByTagId(int)");
                }
            }
        }
        return null;
    }

    private Collection<Document> getDocumentsByTagIds(List<Integer> tagIds) {
        ConnectionSource connectionSource = null;
        try {
            List<Document> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Object daoTags = DaoManager.createDao(connectionSource, DocumentTagConnection.class);
            QueryBuilder qb = dao.queryBuilder();
            QueryBuilder qbTags = daoTags.queryBuilder();
            qbTags.where().in("tag", tagIds);
            qb.join(qbTags);
            qb.distinct();
            System.out.println("Query: " + qb.prepareStatementString());
            List<Document> list = ret = dao.query(qb.prepare());
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentsByTagId(int)");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentsByTagId(int)");
                }
            }
        }
        return null;
    }

    @Override
    public DocumentType getDocumentType(int id) throws UnknownDocumentTypeException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
            DocumentType ret = (DocumentType)dao.queryForId(id);
            if (ret == null) {
                throw new UnknownDocumentTypeException(id);
            }
            DocumentType documentType = ret;
            return documentType;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentType");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentType");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<DocumentType> getDocumentTypes() {
        ConnectionSource connectionSource = null;
        try {
            List<DocumentType> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
            List<DocumentType> list = ret = dao.queryForAll();
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentTypes");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentTypes");
                }
            }
        }
        return null;
    }

    @Override
    public Tag getTag(int id) throws UnknownTagException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Tag.class);
            Tag ret = (Tag)dao.queryForId(id);
            if (ret == null) {
                throw new UnknownTagException(id);
            }
            Tag tag = ret;
            return tag;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getTags");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getTags");
                }
            }
        }
        return null;
    }

    @Override
    public Tag getTag(String name) throws UnknownTagException {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Tag.class);
            Tag ret = (Tag)dao.queryForFirst(dao.queryBuilder().where().eq("name", name).prepare());
            if (ret == null) {
                throw new UnknownTagException(0);
            }
            Tag tag = ret;
            return tag;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getTag");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getTag");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<Tag> getTags() {
        ConnectionSource connectionSource = null;
        try {
            List<Tag> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Tag.class);
            List<Tag> list = ret = dao.queryForAll();
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getTags");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getTags");
                }
            }
        }
        return null;
    }

    private void HandleSQLException(SQLException e, String method) {
        System.err.println("Exception @ " + method);
        e.printStackTrace();
    }

    @Override
    public void removeComment(int id) {
        this.genericDelete(id, Comment.class, "removeComment");
    }

    @Override
    public void removeDefaultMetadata(int id) {
        this.genericDelete(id, DefaultMetadata.class, "removeDefaultMetadata");
    }

    @Override
    public void removeDocument(int id) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, Document.class);
                    dao.deleteById(id);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "removeDocument");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "removeDocument");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "removeDocument");
                    }
                }
            }
        }
    }

    @Override
    public void removeDocumentType(int id) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
                    dao.deleteById(id);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "removeDocumentType");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "removeDocumentType");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "removeDocumentType");
                    }
                }
            }
        }
    }

    @Override
    public void removeMetadata(int id) {
        this.genericDelete(id, Metadata.class, "removeMetadata");
    }

    @Override
    public void removeTag(int id) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, Tag.class);
                    dao.deleteById(id);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "removeTag");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "removeTag");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "removeTag");
                    }
                }
            }
        }
    }

    @Override
    public void updateComment(Comment comment) {
        this.genericUpdate(comment, Comment.class, "updateComment");
    }

    @Override
    public void updateDefaultMetadata(DefaultMetadata metadata) {
        this.genericUpdate(metadata, DefaultMetadata.class, "updateDefaultMetadata");
    }

    @Override
    public void updateDocument(Document document) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, Document.class);
                    dao.update((Document)document);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "updateDocument");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "updateDocument");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "updateDocument");
                    }
                }
            }
        }
    }

    @Override
    public void updateDocumentType(DocumentType documentType) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
                    dao.update((DocumentType)documentType);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "updateDocumentType");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "updateDocumentType");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "updateDocumentType");
                    }
                }
            }
        }
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        this.genericUpdate(metadata, Metadata.class, "updateMetadata");
    }

    @Override
    public void updateTag(Tag tag) {
        block12: {
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, Tag.class);
                    dao.update((Tag)tag);
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "updateTag");
                    if (connectionSource == null) break block12;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "updateTag");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "updateTag");
                    }
                }
            }
        }
    }

    @Override
    public Collection<Document> searchDocuments(SearchExpression sexpr) {
        ConnectionSource connectionSource = null;
        try {
            List<Document> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Object daoMD = DaoManager.createDao(connectionSource, Metadata.class);
            QueryBuilder qb = dao.queryBuilder();
            QueryBuilder qbMD = daoMD.queryBuilder();
            qb.join(qbMD);
            Where where = qbMD.where();
            for (Expression expr : sexpr.getExpressions()) {
                where.eq("name", expr.getMetadataName());
                switch (expr.getOperator()) {
                    case eq: {
                        where.and().eq("value", expr.getValue());
                        break;
                    }
                    case ge: {
                        where.and().ge("value", expr.getValue());
                        break;
                    }
                    case gt: {
                        where.and().gt("value", expr.getValue());
                        break;
                    }
                    case contains: {
                        where.and().like("value", "%" + expr.getValue() + "%");
                        break;
                    }
                    case notcontains: {
                        where.and().not().like("value", "%" + expr.getValue() + "%");
                        break;
                    }
                    case le: {
                        where.and().le("value", expr.getValue());
                        break;
                    }
                    case like: {
                        where.and().like("value", expr.getValue());
                        break;
                    }
                    case lt: {
                        where.and().lt("value", expr.getValue());
                        break;
                    }
                    case neq: {
                        where.and().ne("value", expr.getValue());
                        break;
                    }
                    case between: {
                        where.and().ge("value", expr.getValue(0)).and().le("value", expr.getValue(1));
                        break;
                    }
                }
            }
            if (sexpr.getBoolOperator() == BoolOperator.or) {
                where.or(sexpr.getExpressions().size());
            } else {
                where.and(sexpr.getExpressions().size());
            }
            System.out.println("Search for: " + where.getStatement());
            List<Document> list = ret = dao.query(qb.prepare());
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "searchDocuments(SearchExpression)");
        }
        catch (InvalidParameterException e) {
            System.err.println("Error with search expression.");
            return null;
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "searchDocuments(SearchExpression)");
                }
            }
        }
        return null;
    }

    @Override
    public void addTagToDocument(Tag tag, Document document) throws InvalidParameterException {
        if (tag == null || !DataHelper.isValidId(tag.getId())) {
            throw new InvalidParameterException("tag");
        }
        if (document == null) {
            throw new InvalidParameterException("document");
        }
        DocumentTagConnection dtc = new DocumentTagConnection();
        dtc.setDocument(document);
        dtc.setTag(tag);
        dtc = this.genericCreate(DocumentTagConnection.class, dtc, "addTagToDocument");
        this.genericUpdate(dtc, DocumentTagConnection.class, "addTagToDocument");
    }

    @Override
    public void removeTagFromDocument(Tag tag, Document document) throws InvalidParameterException {
        block14: {
            if (tag == null || !DataHelper.isValidId(tag.getId())) {
                throw new InvalidParameterException("tag");
            }
            if (document == null) {
                throw new InvalidParameterException("document");
            }
            ConnectionSource connectionSource = null;
            try {
                try {
                    connectionSource = DatabaseUtils.getConnectionSource();
                    Object dao = DaoManager.createDao(connectionSource, DocumentTagConnection.class);
                    DeleteBuilder db = dao.deleteBuilder();
                    db.where().eq("document", document.getId()).and().eq("tag", tag.getId());
                    dao.delete(db.prepare());
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "removeTagFromDocument");
                    if (connectionSource == null) break block14;
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e2) {
                        this.HandleSQLException(e2, "removeTagFromDocument");
                    }
                }
            }
            finally {
                if (connectionSource != null) {
                    try {
                        connectionSource.close();
                    }
                    catch (SQLException e) {
                        this.HandleSQLException(e, "removeTagFromDocument");
                    }
                }
            }
        }
    }

    @Override
    public Collection<DocumentFilePointer> getDocumentPointers(String locationFilter) {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            QueryBuilder qb = dao.queryBuilder();
            if (locationFilter != null) {
                qb.where().like("location", locationFilter);
            }
            List documents = dao.query(qb.prepare());
            ArrayList<DocumentFilePointer> ret = new ArrayList<DocumentFilePointer>();
            for (Document doc : documents) {
                if (doc.getLocation() == null) continue;
                ret.add(DocumentFilePointer.createInstance(doc));
            }
            ArrayList<DocumentFilePointer> arrayList = ret;
            return arrayList;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentPointers(String)");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentPointers(String)");
                }
            }
        }
        return null;
    }

    @Override
    public DocumentType getDocumentTypeForExtension(String extension) {
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, DocumentType.class);
            QueryBuilder qb = dao.queryBuilder();
            qb.where().like("defaultExt", "%" + extension + "%");
            List ret = dao.query(qb.prepare());
            if (ret.size() == 0) {
                return null;
            }
            DocumentType documentType = (DocumentType)ret.get(0);
            return documentType;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getDocumentTypes");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getDocumentTypes");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<Document> searchDocumentsFreeText(String textFragment) {
        if (textFragment == null) {
            return new ArrayList<Document>();
        }
        String expr = "%" + textFragment.replace('%', '_') + "%";
        ConnectionSource connectionSource = null;
        try {
            List<Document> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Document.class);
            Object daoMD = DaoManager.createDao(connectionSource, Metadata.class);
            QueryBuilder qb = dao.queryBuilder();
            QueryBuilder qbMD = daoMD.queryBuilder();
            QueryBuilder joinedQb = qb.join(qbMD);
            Where where = qbMD.where();
            where.like("value", expr);
            List<Document> list = ret = dao.query(joinedQb.prepare());
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "searchDocumentsFreeText(String)");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "searchDocumentsFreeText(String)");
                }
            }
        }
        return null;
    }

    private Collection<Metadata> getAllMetadata() {
        ConnectionSource connectionSource = null;
        try {
            List<Metadata> ret;
            connectionSource = DatabaseUtils.getConnectionSource();
            Object dao = DaoManager.createDao(connectionSource, Metadata.class);
            List<Metadata> list = ret = dao.queryForAll();
            return list;
        }
        catch (SQLException e) {
            this.HandleSQLException(e, "getAllMetadata");
        }
        finally {
            if (connectionSource != null) {
                try {
                    connectionSource.close();
                }
                catch (SQLException e) {
                    this.HandleSQLException(e, "getAllMetadata");
                }
            }
        }
        return null;
    }

    @Override
    public Collection<MetadataNameTypePair> getAllMetadataKeys() {
        HashSet<MetadataNameTypePair> set = new HashSet<MetadataNameTypePair>();
        for (Metadata md : this.getAllMetadata()) {
            MetadataNameTypePair pair = new MetadataNameTypePair(md.getName(), md.getMetadataType());
            set.add(pair);
        }
        return set;
    }
}

