/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.dal.interfaces;

import hu.documaison.data.entities.Comment;
import hu.documaison.data.entities.DefaultMetadata;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.entities.Tag;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.exceptions.UnknownDocumentTypeException;
import hu.documaison.data.exceptions.UnknownTagException;
import hu.documaison.data.helper.DocumentFilePointer;
import hu.documaison.data.helper.MetadataNameTypePair;
import hu.documaison.data.search.SearchExpression;
import java.util.Collection;
import java.util.List;

public interface DalInterface {
    public Collection<Document> getDocuments();

    public Collection<Document> getDocumentsByTag(Tag var1);

    public Collection<Document> getDocumentsByTags(List<Tag> var1);

    public Document getDocument(int var1) throws UnknownDocumentException;

    public Document createDocument(int var1) throws UnknownDocumentTypeException, UnableToCreateException;

    public void removeDocument(int var1);

    public void updateDocument(Document var1);

    public Tag createTag(String var1) throws UnableToCreateException;

    public void updateTag(Tag var1);

    public Collection<Tag> getTags();

    public Tag getTag(int var1) throws UnknownTagException;

    public Tag getTag(String var1) throws UnknownTagException;

    public void removeTag(int var1);

    public void addTagToDocument(Tag var1, Document var2) throws InvalidParameterException;

    public void removeTagFromDocument(Tag var1, Document var2) throws InvalidParameterException;

    public DocumentType createDocumentType() throws UnableToCreateException;

    public void removeDocumentType(int var1);

    public void updateDocumentType(DocumentType var1);

    public Collection<DocumentType> getDocumentTypes();

    public DocumentType getDocumentType(int var1) throws UnknownDocumentTypeException;

    public DocumentType getDocumentTypeForExtension(String var1);

    public Metadata createMetadata() throws UnableToCreateException;

    public void updateMetadata(Metadata var1);

    public void removeMetadata(int var1);

    public Collection<MetadataNameTypePair> getAllMetadataKeys();

    public DefaultMetadata createDefaultMetadata() throws UnableToCreateException;

    public void updateDefaultMetadata(DefaultMetadata var1);

    public void removeDefaultMetadata(int var1);

    public Comment createComment() throws UnableToCreateException;

    public void updateComment(Comment var1);

    public void removeComment(int var1);

    public Collection<Document> searchDocuments(SearchExpression var1);

    public Collection<Document> searchDocumentsFreeText(String var1);

    public Collection<DocumentFilePointer> getDocumentPointers(String var1);
}

