/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.data.entities;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import hu.documaison.data.entities.DatabaseObject;
import hu.documaison.data.entities.MetadataType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractMetadata
extends DatabaseObject {
    public static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public static final String NAME = "name";
    public static final String PARENT = "parent";
    public static final String VALUE = "value";
    @DatabaseField(dataType=DataType.ENUM_INTEGER)
    protected MetadataType metadataType = MetadataType.Text;
    @DatabaseField(canBeNull=true, columnName="name")
    protected String name;
    @DatabaseField(canBeNull=true, columnName="value")
    protected String value = null;

    public Date getDateValue() {
        if (this.getMetadataType() == MetadataType.Date) {
            try {
                return DATEFORMAT.parse(this.getValueInternal());
            }
            catch (ParseException e) {
                System.err.println("Unable to convert data: " + this.getValueInternal());
            }
        } else {
            System.err.println("Unable to convert data.");
        }
        return null;
    }

    public int getIntValue() {
        if (this.getMetadataType() == MetadataType.Integer) {
            try {
                return Integer.parseInt(this.getValueInternal());
            }
            catch (NumberFormatException e) {
                System.err.println("Unable to convert data: " + this.getValueInternal());
            }
        } else {
            System.err.println("Unable to convert data.");
        }
        return -1;
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected String getValueInternal() {
        return this.value;
    }

    private static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isDate(String str) {
        if (str == null) {
            return false;
        }
        try {
            DATEFORMAT.parse(str);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public void setMetadataType(MetadataType metadataType) {
        MetadataType oldType = this.metadataType;
        this.metadataType = metadataType;
        if (oldType == this.metadataType || this.value == null) {
            return;
        }
        switch (this.metadataType) {
            case Text: {
                break;
            }
            case Date: {
                if (oldType == MetadataType.Text && AbstractMetadata.isDate(this.value)) break;
                this.value = null;
                break;
            }
            case Integer: {
                if (oldType == MetadataType.Text && AbstractMetadata.isInteger(this.value)) break;
                this.value = null;
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Date date) {
        if (this.getMetadataType() == MetadataType.Date) {
            this.setValueInternal(DATEFORMAT.format(date));
        } else {
            System.err.println("Unable to convert data.");
        }
    }

    public void setValue(int x) {
        if (this.getMetadataType() == MetadataType.Integer) {
            this.setValueInternal(Integer.toString(x));
        } else {
            System.err.println("Unable to convert data.");
        }
    }

    public void setValue(String value) {
        if (this.getMetadataType() == MetadataType.Text) {
            this.setValueInternal(value);
        } else {
            System.err.println("Unable to convert data.");
        }
    }

    protected void setValueInternal(String value) {
        this.value = value;
    }
}

