/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.data.entities;

import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import hu.documaison.data.entities.AbstractMetadata;
import hu.documaison.data.entities.Comment;
import hu.documaison.data.entities.DatabaseObject;
import hu.documaison.data.entities.DocumentTagConnection;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.entities.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

@DatabaseTable(tableName="Documents")
public class Document
extends DatabaseObject {
    public static final String TAGS = "tags";
    public static final String METADATA = "metadata";
    public static final String COMMENTS = "comments";
    public static final String LOCATION = "location";
    protected static final String CREATOR_COMPUTERID = "creator_computerid";
    @DatabaseField(columnName="location")
    private String location;
    @DatabaseField(columnName="creator_computerid")
    private String creatorComputerId;
    @DatabaseField(foreign=true, foreignAutoRefresh=true)
    private DocumentType type;
    @DatabaseField
    private Date dateAdded;
    @DatabaseField(dataType=DataType.BYTE_ARRAY)
    private byte[] thumbnailBytes;
    @ForeignCollectionField(eager=true, columnName="tags")
    private ForeignCollection<DocumentTagConnection> tags;
    @ForeignCollectionField(eager=true, columnName="metadata")
    private ForeignCollection<Metadata> metadataCollection;
    @ForeignCollectionField(eager=true, columnName="comments")
    private ForeignCollection<Comment> commentCollection;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCreatorComputerId() {
        return this.creatorComputerId;
    }

    public void setCreatorComputerId(String creatorComputerId) {
        this.creatorComputerId = creatorComputerId;
    }

    public DocumentType getType() {
        return this.type;
    }

    public void setType(DocumentType type) {
        this.type = type;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public byte[] getThumbnailBytes() {
        return this.thumbnailBytes;
    }

    public void setThumbnailBytes(byte[] thumbnailBytes) {
        this.thumbnailBytes = thumbnailBytes;
    }

    public Collection<Tag> getTags() {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        if (this.tags != null) {
            for (DocumentTagConnection dtc : this.tags) {
                ret.add(dtc.getTag());
            }
        }
        return ret;
    }

    public Collection<Metadata> getMetadataCollection() {
        return this.metadataCollection;
    }

    public Metadata getMetadata(String metadataName) {
        if (this.metadataCollection == null) {
            return null;
        }
        for (Metadata md : this.metadataCollection) {
            if (!md.getName().equals(metadataName)) continue;
            return md;
        }
        return null;
    }

    public void addMetadata(Metadata metadata) {
        this.metadataCollection.add(metadata);
    }

    public void removeMetadata(AbstractMetadata metadata) {
        this.metadataCollection.remove(metadata);
    }

    public Collection<Comment> getCommentCollection() {
        return this.commentCollection;
    }

    public void addComment(Comment comment) {
        this.commentCollection.add(comment);
    }

    public void removeComment(Comment comment) {
        this.commentCollection.remove(comment);
    }
}

