/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.data.entities;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import hu.documaison.data.entities.DatabaseObject;
import hu.documaison.data.entities.DefaultMetadata;
import java.sql.SQLException;
import java.util.Collection;

@DatabaseTable(tableName="DocumentTypes")
public class DocumentType
extends DatabaseObject {
    public static final String METADATA = "metadata";
    public static final String DEFAULTEXTS = "defaultExt";
    @DatabaseField
    private String typeName;
    @DatabaseField(columnName="defaultExt")
    private String defaultExt;
    @DatabaseField(dataType=DataType.BYTE_ARRAY)
    private byte[] defaultThumbnailBytes;
    @ForeignCollectionField(eager=true, foreignFieldName="parent", columnName="metadata")
    private ForeignCollection<DefaultMetadata> defaultMetadataCollection;

    public DocumentType() {
    }

    public DocumentType(Dao<DocumentType, Integer> dao) throws SQLException {
        this.defaultMetadataCollection = dao.getEmptyForeignCollection(METADATA);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getDefaultExt() {
        return this.defaultExt;
    }

    public void setDefaultExt(String defaultExt) {
        this.defaultExt = defaultExt;
    }

    public byte[] getDefaultThumbnailBytes() {
        return this.defaultThumbnailBytes;
    }

    public void setDefaultThumbnailBytes(byte[] defaultThumbnailBytes) {
        this.defaultThumbnailBytes = defaultThumbnailBytes;
    }

    public Collection<DefaultMetadata> getDefaultMetadataCollection() {
        return this.defaultMetadataCollection;
    }

    public void addMetadata(DefaultMetadata metadata) {
        this.defaultMetadataCollection.add(metadata);
    }

    public void removeMetadata(DefaultMetadata metadata) {
        this.defaultMetadataCollection.remove(metadata);
    }

    public String toString() {
        return this.typeName;
    }
}

