/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.data.helper;

import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Metadata;

public class DataHelper {
    public static boolean isValidId(int id) {
        return id > 0;
    }

    public static boolean isURL(String string) {
        return string != null && (string.startsWith("http://") || string.startsWith("https://"));
    }

    public static String createBibTex(Document doc) {
        Metadata location;
        Metadata author;
        String ret = "@Article{article" + doc.getId() + ",\n";
        Metadata title = doc.getMetadata("title");
        if (title == null) {
            title = doc.getMetadata("Title");
        }
        if (title != null) {
            ret = ret.concat("\ttitle = \"" + title.getValue() + "\",\n");
        }
        if ((author = doc.getMetadata("author")) == null) {
            author = doc.getMetadata("Author");
        }
        if (author != null) {
            ret = ret.concat("\tauthor = \"" + author.getValue() + "\",\n");
        }
        if ((location = doc.getMetadata("location")) == null) {
            location = doc.getMetadata("Location");
        }
        if (location != null && DataHelper.isURL(location.getValue())) {
            ret = ret.concat("\turl = \"" + location.getValue() + "\",\n");
        }
        return ret.concat("}");
    }
}

