/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.data.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileHelper {
    public static boolean copy(File source, File destination) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int bytesRead;
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static String fileExtension(String path) {
        int lastDot = path.lastIndexOf(46);
        return path.substring(lastDot + 1);
    }

    public static File createFileObject(String location) {
        try {
            File ret = new File(location);
            return ret;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public static String fileName(String path) {
        return new File(path).getName();
    }
}

