/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui;

import hu.documaison.Application;
import hu.documaison.data.exceptions.InvalidFolderException;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.SettingsAccessException;
import hu.documaison.gui.LeftPanel;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.RightPanel;
import hu.documaison.gui.ViewManager;
import hu.documaison.gui.commentstags.TagPanel;
import hu.documaison.gui.document.DocumentLister;
import hu.documaison.indexing.AutomaticIndexing;
import hu.documaison.indexing.ConcreteIndexerInterceptor;
import hu.documaison.indexing.IndexerCollection;
import hu.documaison.indexing.IndexerFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public class DocuMaisonWindow {
    private MenuItem refreshMenu;
    private MenuItem settingsMenu;
    private MenuItem closeMenu;
    private MenuItem newMenu;
    private MenuItem allDocs;
    private MenuItem search;
    private MenuItem manageDocTypes;
    private IndexerCollection collection;

    public static void main(String[] args) {
        DocuMaisonWindow w = new DocuMaisonWindow();
        w.showWindow();
    }

    private void showWindow() {
        Display.setAppName("DocuMaison");
        Display display = new Display();
        final Shell shell = new Shell(display);
        this.prepareIcons(shell);
        shell.setLayout(new FormLayout());
        final Sash sash = new Sash(shell, 66048);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 230);
        sash.setLayoutData(data);
        LeftPanel tagPanel = new LeftPanel(shell, 2112);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(sash, 0);
        tagPanel.setLayoutData(data);
        RightPanel rightPanel = new RightPanel(shell, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(sash, 0);
        data.right = new FormAttachment(100, 0);
        rightPanel.setLayoutData(data);
        sash.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                sash.setBounds(e.x, e.y, e.width, e.height);
                FormData formData = new FormData();
                formData.top = new FormAttachment(0, 0);
                formData.left = new FormAttachment(0, e.x);
                formData.bottom = new FormAttachment(100, 0);
                formData.height = 3;
                sash.setLayoutData(formData);
                shell.layout(true);
            }
        });
        this.createMenus(shell);
        try {
            this.collection = IndexerFactory.getAllIndexers(Application.getBll());
            this.collection.getDispatcher().register(new ConcreteIndexerInterceptor());
            AutomaticIndexing.setIndexers(this.collection);
            AutomaticIndexing.initialize();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DocuMaisonWindow.this.collection.refreshAll();
                }
            }).start();
        }
        catch (InvalidFolderException e1) {
            NotificationWindow.showError("Indexing error", "Faild to create indexer for one of the directories (+ " + e1 + ")");
        }
        catch (SettingsAccessException e1) {
            NotificationWindow.showError("Error", "Can't acces the settings file.");
        }
        catch (InvalidParameterException e1) {
            NotificationWindow.showError("Error", "Invalid parameter exception: " + e1.getMessage());
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void prepareIcons(Shell window) {
        Display display = window.getDisplay();
        Image icon16 = new Image((Device)display, "images/icon_16x16.png");
        Image icon32 = new Image((Device)display, "images/icon_32x32.png");
        Image icon128 = new Image((Device)display, "images/icon_128x128.png");
        window.setImages(new Image[]{icon16, icon32, icon128});
    }

    private void createMenus(Shell shell) {
        Menu menubar = new Menu(shell, 2);
        MenuItem fileMenuHeader = new MenuItem(menubar, 64);
        fileMenuHeader.setText("&File");
        Menu fileMenu = new Menu(shell, 4);
        fileMenuHeader.setMenu(fileMenu);
        this.refreshMenu = new MenuItem(fileMenu, 8);
        this.refreshMenu.setText("&Refresh indexers");
        this.settingsMenu = new MenuItem(fileMenu, 8);
        this.settingsMenu.setText("&Preferences");
        this.closeMenu = new MenuItem(fileMenu, 8);
        this.closeMenu.setText("&Close");
        Menu docMenu = new Menu(shell, 4);
        MenuItem docMenuHeader = new MenuItem(menubar, 64);
        docMenuHeader.setText("&Documents");
        docMenuHeader.setMenu(docMenu);
        this.newMenu = new MenuItem(docMenu, 8);
        this.newMenu.setText("&Add new document");
        this.allDocs = new MenuItem(docMenu, 8);
        this.allDocs.setText("Show all documents");
        this.search = new MenuItem(docMenu, 8);
        this.search.setText("Advanced search");
        this.manageDocTypes = new MenuItem(docMenu, 8);
        this.manageDocTypes.setText("Manage document &types");
        shell.setMenuBar(menubar);
        this.addMenuListeners();
    }

    private void addMenuListeners() {
        this.settingsMenu.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ViewManager.getDefault().showView("settings");
            }
        });
        this.closeMenu.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                Display.getDefault().getActiveShell().dispose();
            }
        });
        this.newMenu.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ViewManager.getDefault().showView("newDocument");
            }
        });
        this.allDocs.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                DocumentLister lister = (DocumentLister)ViewManager.getDefault().getView("documents");
                TagPanel.clearSelection(false);
                lister.showAll();
                ViewManager.getDefault().showView(lister);
            }
        });
        this.search.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ViewManager.getDefault().showView("advancedSearch");
            }
        });
        this.manageDocTypes.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ViewManager.getDefault().showView("doctypeeditor");
            }
        });
        this.refreshMenu.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (DocuMaisonWindow.this.collection != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DocuMaisonWindow.this.collection.refreshAll();
                        }
                    }).start();
                }
            }
        });
    }
}

