/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui;

import hu.documaison.gui.ViewManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.breadcrumb.Breadcrumb;
import org.mihalis.opal.breadcrumb.BreadcrumbItem;

public abstract class InnerPanel
extends Composite {
    protected BreadcrumbItem home;
    protected BreadcrumbItem item;
    protected Label titleLabel;
    protected InnerPanel previous = null;
    private Breadcrumb breadcrumb;
    private final String title;
    private BreadcrumbItem newItem;

    public InnerPanel(Composite parent, int style, String title) {
        super(parent, style);
        this.title = title;
        FormLayout layout = new FormLayout();
        this.setLayout(layout);
        this.createBreadcrumb();
        this.titleLabel = new Label(this, 0);
        this.titleLabel.setText(title);
        FontData[] fD = this.titleLabel.getFont().getFontData();
        fD[0].setHeight(16);
        this.titleLabel.setFont(new Font(null, fD[0]));
        FormData data = new FormData();
        data.top = new FormAttachment(0, 40);
        data.left = new FormAttachment(0, 10);
        this.titleLabel.setLayoutData(data);
        this.createComposite();
    }

    private void createBreadcrumb() {
        this.breadcrumb = new Breadcrumb(this, 1);
        this.home = new BreadcrumbItem(this.breadcrumb, 8);
        this.home.setText("  DocuMaison  ");
        this.item = new BreadcrumbItem(this.breadcrumb, 8);
        this.item.setText("  " + this.title + "  ");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.breadcrumb.setLayoutData(data);
        this.breadcrumb.pack();
    }

    protected abstract void createComposite();

    public void addHomeSelectionListener(SelectionListener listener) {
        this.home.addSelectionListener(listener);
    }

    public void setPreviousPanel(final InnerPanel panel) {
        this.previous = panel;
        if (panel != null) {
            this.item.setText("  " + panel.getTitle() + "  ");
            this.item.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    ViewManager.getDefault().showView(panel);
                }
            });
            this.newItem = new BreadcrumbItem(this.breadcrumb, 8);
            this.newItem.setText("  " + this.title + "  ");
        } else if (panel == null) {
            this.breadcrumb.dispose();
            this.createBreadcrumb();
            this.layout();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void showed() {
        this.layout();
    }
}

