/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui;

import hu.documaison.gui.InnerPanel;
import java.util.HashMap;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;

public class MultiPanel
extends Composite {
    private final HashMap<String, InnerPanel> sheetMap = new HashMap();
    private Composite currentSheet = null;
    private final FormLayout layout = new FormLayout();

    public MultiPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout(this.layout);
    }

    public void addSheet(InnerPanel sheet, String id) {
        this.sheetMap.put(id, sheet);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        sheet.setLayoutData(data);
        if (this.currentSheet != null) {
            this.currentSheet.setVisible(false);
        }
        this.currentSheet = sheet;
        sheet.setVisible(true);
        sheet.showed();
        this.layout();
    }

    public InnerPanel selectSheet(String id) {
        InnerPanel sheet = this.sheetMap.get(id);
        return this.selectSheet(sheet);
    }

    public InnerPanel selectSheet(InnerPanel sheet) {
        if (this.currentSheet != null) {
            this.currentSheet.setVisible(false);
        }
        this.currentSheet = sheet;
        sheet.setPreviousPanel(null);
        sheet.setVisible(true);
        sheet.showed();
        this.layout();
        return sheet;
    }

    public InnerPanel selectSheet(String id, InnerPanel previous) {
        InnerPanel sheet = this.selectSheet(id);
        sheet.setPreviousPanel(previous);
        sheet.showed();
        return sheet;
    }

    public InnerPanel getSheet(String id) {
        return this.sheetMap.get(id);
    }
}

