/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.commentstags;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Tag;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.exceptions.UnknownTagException;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.commentstags.ColorMap;
import hu.documaison.gui.commentstags.TagPanel;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddTagDialog {
    private Button existingRadio;
    private Button newRadio;
    private Combo existingCombo;
    private Text newTagName;
    private Combo colorCombo;
    private Button saveBtn;
    private Document doc;
    private Shell dialog;

    public void showAndHandle(Shell parent, Document document) {
        try {
            this.doc = Application.getBll().getDocument(document.getId());
        }
        catch (UnknownDocumentException e) {
            this.doc = document;
            NotificationWindow.showError("Database error", "Failed to update the document from the database.");
        }
        this.dialog = new Shell(parent, 67680);
        this.dialog.setText("Add new tag");
        this.dialog.setSize(500, 150);
        this.dialog.setLayout(new FillLayout());
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new FormLayout());
        this.existingRadio = new Button(composite, 16);
        this.existingRadio.setText("Existing tag:");
        this.newRadio = new Button(composite, 16);
        this.newRadio.setText("New tag:");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment(0, 10);
        this.existingRadio.setLayoutData(data);
        this.existingRadio.setSelection(true);
        data = new FormData();
        data.top = new FormAttachment(this.existingRadio, 15);
        data.left = new FormAttachment(0, 10);
        this.newRadio.setLayoutData(data);
        this.newRadio.setSelection(false);
        this.existingCombo = new Combo(composite, 12);
        for (Tag tag : Application.getBll().getTags()) {
            if (tag.getName() == null) continue;
            this.existingCombo.add(tag.getName());
        }
        if (this.existingCombo.getItemCount() == 0) {
            this.existingRadio.setEnabled(false);
            this.newRadio.setSelection(true);
        }
        data = new FormData();
        data.top = new FormAttachment(this.existingRadio, 0, 0x1000000);
        data.left = new FormAttachment(this.existingRadio, 10);
        this.existingCombo.setLayoutData(data);
        this.newTagName = new Text(composite, 2048);
        if (this.existingCombo.getItemCount() > 0) {
            this.newTagName.setEnabled(false);
        }
        data = new FormData();
        data.top = new FormAttachment(this.newRadio, 0, 0x1000000);
        data.left = new FormAttachment(this.existingRadio, 10);
        data.width = 200;
        this.newTagName.setLayoutData(data);
        this.colorCombo = new Combo(composite, 12);
        if (this.existingCombo.getItemCount() > 0) {
            this.colorCombo.setEnabled(false);
        }
        ArrayList<String> colors = new ArrayList<String>(ColorMap.get().getColors());
        Collections.sort(colors);
        for (String color : colors) {
            this.colorCombo.add(color);
        }
        data = new FormData();
        data.top = new FormAttachment(this.newRadio, 0, 0x1000000);
        data.left = new FormAttachment(this.newTagName, 5);
        this.colorCombo.setLayoutData(data);
        this.colorCombo.select(0);
        this.saveBtn = new Button(composite, 8);
        this.saveBtn.setText("Add tag");
        data = new FormData();
        data.bottom = new FormAttachment(100, -15);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(100, -20);
        this.saveBtn.setLayoutData(data);
        this.saveBtn.setEnabled(false);
        this.addEventListeners();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void addEventListeners() {
        this.existingRadio.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog.this.newTagName.setEnabled(false);
                AddTagDialog.this.colorCombo.setEnabled(false);
                AddTagDialog.this.existingCombo.setEnabled(true);
                AddTagDialog.this.existingCombo.setFocus();
                AddTagDialog.this.validate();
            }
        });
        this.newRadio.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog.this.newTagName.setEnabled(true);
                AddTagDialog.this.colorCombo.setEnabled(true);
                AddTagDialog.this.existingCombo.setEnabled(false);
                AddTagDialog.this.newTagName.setFocus();
                AddTagDialog.this.validate();
            }
        });
        this.existingCombo.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog.this.validate();
            }
        });
        this.newTagName.addListener(25, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog.this.validate();
            }
        });
        this.colorCombo.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog.this.validate();
            }
        });
        this.saveBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    if (AddTagDialog.this.existingRadio.isEnabled() && AddTagDialog.this.existingRadio.getSelection()) {
                        Tag tag = Application.getBll().getTag(AddTagDialog.this.existingCombo.getItem(AddTagDialog.this.existingCombo.getSelectionIndex()));
                        if (!AddTagDialog.this.doc.getTags().contains(tag)) {
                            Application.getBll().addTagToDocument(tag, AddTagDialog.this.doc);
                        }
                    } else {
                        Tag tag = Application.getBll().createTag(AddTagDialog.this.newTagName.getText());
                        tag.setColorName(AddTagDialog.this.colorCombo.getItem(AddTagDialog.this.colorCombo.getSelectionIndex()));
                        tag.setName(AddTagDialog.this.newTagName.getText());
                        Application.getBll().updateTag(tag);
                        tag = Application.getBll().getTag(tag.getId());
                        Application.getBll().addTagToDocument(tag, AddTagDialog.this.doc);
                        TagPanel.refresh();
                    }
                }
                catch (UnableToCreateException e1) {
                    NotificationWindow.showError("Database error", "Failed to save the tag due to an error in the database. (" + e1.getMessage() + ")");
                }
                catch (InvalidParameterException e1) {
                    NotificationWindow.showError("Parameter error", "Can't add the selected tag to the document. (" + e1.getMessage() + ")");
                }
                catch (UnknownTagException e1) {
                    NotificationWindow.showError("Database error", "Unable to locate the selected tag in the database.");
                }
                AddTagDialog.this.dialog.dispose();
            }
        });
    }

    private void validate() {
        if (this.existingRadio.getSelection() && this.existingCombo.getSelectionIndex() != -1) {
            this.saveBtn.setEnabled(true);
        } else if (this.newRadio.getSelection() && !this.newTagName.getText().isEmpty() && this.colorCombo.getSelectionIndex() != -1) {
            this.saveBtn.setEnabled(true);
        } else {
            this.saveBtn.setEnabled(false);
        }
    }
}

