/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.commentstags;

import hu.documaison.Application;
import hu.documaison.data.entities.Comment;
import hu.documaison.data.entities.Document;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.gui.NotificationWindow;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommentDialog {
    public void showAndHandle(Shell parent, final Document document) {
        Shell dialog = new Shell(parent, 67680);
        dialog.setText("Comments");
        dialog.setSize(300, 300);
        dialog.setLayout(new FillLayout());
        Composite composite = new Composite(dialog, 0);
        composite.setLayout(new FormLayout());
        Button storeCommentBtn = new Button(composite, 8);
        storeCommentBtn.setText("Save");
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        storeCommentBtn.setLayoutData(data);
        final Text newComment = new Text(composite, 2052);
        newComment.setToolTipText("New comment");
        data = new FormData();
        data.top = new FormAttachment(storeCommentBtn, 0, 0x1000000);
        data.right = new FormAttachment(storeCommentBtn, 0);
        data.left = new FormAttachment(5, 0);
        newComment.setLayoutData(data);
        final Text viewer = new Text(composite, 2634);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(newComment, -10);
        viewer.setLayoutData(data);
        this.loadComments(viewer, document);
        storeCommentBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CommentDialog.this.storeComment(newComment.getText(), document);
                CommentDialog.this.loadComments(viewer, document);
                newComment.setText("");
            }
        });
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
    }

    private void loadComments(Text viewer, Document doc) {
        viewer.setText("");
        try {
            doc = Application.getBll().getDocument(doc.getId());
            for (Comment c : doc.getCommentCollection()) {
                String commentDate = DateFormat.getDateTimeInstance(2, 3, new Locale("hu", "HU")).format(c.getCreatedDate());
                viewer.setText(String.valueOf(viewer.getText()) + c.getMessage() + " (" + commentDate + ")\n\n");
            }
        }
        catch (UnknownDocumentException e) {
            viewer.setText("Failed to load comments from the database.\n\n" + e.getMessage());
        }
    }

    private void storeComment(String comment, Document doc) {
        try {
            Comment com = Application.getBll().createComment(doc);
            com.setCreatedDate(new Date());
            com.setMessage(comment);
            Application.getBll().updateComment(com);
        }
        catch (UnableToCreateException e) {
            NotificationWindow.showError("Database error", "Failed to store the comment in the database (" + e.getMessage() + ")");
        }
    }
}

