/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.commentstags;

import hu.documaison.data.entities.Tag;
import hu.documaison.gui.commentstags.ColorMap;
import hu.documaison.gui.commentstags.TagPanel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class TagItem
extends Composite
implements MouseListener {
    private boolean selected = false;
    private final Color white = new Color(null, 255, 255, 255);
    private final Color selectionBackground = new Color(null, 43, 89, 190);
    private final Color unselectedBackground;
    private final Image image = new Image((Device)this.getDisplay(), "images/tagIcon.png");
    private final Label textLabel;
    private final TagPanel parentTagPanel;
    private final int index;
    private final Tag tag;
    private Label imageLabel;

    public TagItem(Composite parent, int style, int index, Tag tag, TagPanel parentTagPanel) {
        super(parent, style);
        this.tag = tag;
        this.index = index;
        this.parentTagPanel = parentTagPanel;
        FormLayout layout = new FormLayout();
        this.setLayout(layout);
        this.imageLabel = new Label(this, 0);
        this.imageLabel.setImage(this.image);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 15);
        this.imageLabel.setLayoutData(data);
        this.textLabel = new Label(this, 0);
        this.textLabel.setText(tag.getName());
        int[] rgb = ColorMap.get().getRGB(tag.getColorName());
        if (rgb == null) {
            rgb = ColorMap.get().getRGB("Black");
        }
        this.unselectedBackground = this.getBackground();
        this.textLabel.setForeground(new Color(this.getDisplay(), rgb[0], rgb[1], rgb[2]));
        data = new FormData();
        data.left = new FormAttachment(this.imageLabel, 5);
        data.top = new FormAttachment(this.imageLabel, 0, 0x1000000);
        data.right = new FormAttachment(100, 0);
        this.textLabel.setLayoutData(data);
        this.imageLabel.addMouseListener(this);
        this.textLabel.addMouseListener(this);
        this.addMouseListener(this);
    }

    public void setSelected(boolean value, boolean enableNotification) {
        this.selected = value;
        if (this.selected) {
            this.setBackground(this.selectionBackground);
            this.textLabel.setForeground(this.white);
            this.parentTagPanel.addToSelection(this, enableNotification);
        } else {
            this.setBackground(this.unselectedBackground);
            int[] rgb = ColorMap.get().getRGB(this.tag.getColorName());
            if (rgb == null) {
                rgb = ColorMap.get().getRGB("Black");
            }
            this.textLabel.setForeground(new Color(this.getDisplay(), rgb[0], rgb[1], rgb[2]));
            this.parentTagPanel.removeFromSelection(this, false);
        }
    }

    @Override
    public void mouseDoubleClick(MouseEvent arg0) {
    }

    @Override
    public void mouseDown(MouseEvent e) {
        if ((e.stateMask & 0x40000) == 262144 || (e.stateMask & 0x400000) == 0x400000) {
            this.setSelected(!this.selected, true);
        } else if ((e.stateMask & 0x20000) == 131072) {
            this.parentTagPanel.multipleSelection(this);
        } else if (TagPanel.isSelectionEmpty()) {
            this.setSelected(!this.selected, true);
        } else {
            TagPanel.clearSelection(false);
            this.setSelected(!this.selected, true);
        }
    }

    @Override
    public void mouseUp(MouseEvent arg0) {
    }

    public int getIndex() {
        return this.index;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public void setBackground(Color color) {
        this.imageLabel.setBackground(color);
        this.textLabel.setBackground(color);
        super.setBackground(color);
    }
}

