/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.commentstags;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Tag;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.exceptions.UnknownTagException;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.commentstags.AddTagDialog;
import hu.documaison.gui.commentstags.ColorMap;
import hu.documaison.gui.document.DocumentObserver;
import hu.documaison.gui.document.IDocumentChangeListener;
import java.util.ArrayList;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class TagViewer
extends Composite
implements SelectionListener,
IDocumentChangeListener {
    private final ArrayList<Control> controls = new ArrayList();
    private Document doc;
    private final Composite parent;

    public TagViewer(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        RowLayout layout = new RowLayout();
        layout.wrap = true;
        this.setLayout(layout);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    @Override
    public void widgetSelected(SelectionEvent arg0) {
        Link link;
        if (arg0.getSource() instanceof Link && (link = (Link)arg0.getSource()).getData() != null) {
            Tag tag = (Tag)link.getData();
            try {
                Application.getBll().removeTagFromDocument(tag, this.doc);
                Application.getBll().updateDocument(this.doc);
                DocumentObserver.notify(this.doc.getId(), null);
            }
            catch (InvalidParameterException e) {
                NotificationWindow.showError("Error", "Failed to remove tag from document.");
            }
        }
    }

    public void createControls(final Document doc) {
        if (this.doc != doc) {
            if (this.doc != null) {
                DocumentObserver.detach(this.doc.getId(), this);
            }
            DocumentObserver.attach(doc.getId(), this);
        }
        this.doc = doc;
        Document updatedDoc = doc;
        try {
            updatedDoc = Application.getBll().getDocument(doc.getId());
        }
        catch (UnknownDocumentException e1) {
            NotificationWindow.showError("Database error", "Failed to update the document from the database.");
        }
        for (Control c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        if (updatedDoc.getTags() == null || updatedDoc.getTags().size() == 0) {
            Label emptyLabel = new Label(this, 64);
            emptyLabel.setText("No tags...");
            this.controls.add(emptyLabel);
        } else {
            for (Tag tag : updatedDoc.getTags()) {
                try {
                    tag = Application.getBll().getTag(tag.getId());
                }
                catch (UnknownTagException e1) {
                    NotificationWindow.showError("Database error", "Failed to update tag from database.");
                }
                Link link = new Link(this, 16);
                this.controls.add(link);
                link.setText(String.valueOf(tag.getName()) + " (<a>X</a>)");
                int[] rgb = ColorMap.get().getRGB(tag.getColorName());
                if (rgb == null) {
                    rgb = ColorMap.get().getRGB("Black");
                }
                link.setForeground(new Color(this.getDisplay(), rgb[0], rgb[1], rgb[2]));
                link.setData(tag);
                link.addSelectionListener(this);
            }
        }
        Link addLink = new Link(this, 16);
        this.controls.add(addLink);
        addLink.setText("<a>Add new</a>");
        addLink.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddTagDialog ATD = new AddTagDialog();
                ATD.showAndHandle(TagViewer.this.getShell(), doc);
                TagViewer.this.createControls(doc);
                DocumentObserver.notify(doc.getId(), TagViewer.this);
            }
        });
        this.pack();
        this.layout();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        for (Control control : this.controls) {
            control.setBackground(c);
        }
    }

    @Override
    public void dispose() {
        if (this.doc != null) {
            DocumentObserver.detach(this.doc.getId(), this);
        }
        super.dispose();
    }

    @Override
    public void documentChanged() {
        this.createControls(this.doc);
        this.pack();
    }

    @Override
    public void addMouseListener(MouseListener arg0) {
        for (Control c : this.controls) {
            c.addMouseListener(arg0);
        }
        super.addMouseListener(arg0);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(this.parent.getBounds().width, hHint, changed);
    }
}

