/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.doctype;

import hu.documaison.Application;
import hu.documaison.data.entities.DefaultMetadata;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.exceptions.UnknownDocumentTypeException;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.ViewManager;
import hu.documaison.gui.doctype.DocumentTypeDialog;
import hu.documaison.gui.doctype.MetadataDialog;
import java.util.Collection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DocTypeEditor
extends InnerPanel {
    private Tree tree;
    private Button removeDocTypeBtn;
    private Button addMetadataBtn;
    private Button editMetadataBtn;
    private Button removeMetadataBtn;
    private Button addNewDocTypeBtn;
    private Button editDocTypeBtn;
    private Button doneBtn;

    public DocTypeEditor(Composite parent, int style) {
        super(parent, style, "Document type manager");
    }

    @Override
    protected void createComposite() {
        Label label = new Label(this, 0);
        label.setText("Here you can modify the document types of the application.");
        FormData data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        label.setLayoutData(data);
        this.addNewDocTypeBtn = new Button(this, 8);
        this.addNewDocTypeBtn.setText("Add new type");
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.width = 200;
        data.top = new FormAttachment(label, 25);
        this.addNewDocTypeBtn.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(this.addNewDocTypeBtn, -10);
        data.top = new FormAttachment(label, 25);
        data.bottom = new FormAttachment(100, -20);
        this.tree = new Tree(this, 0x10000A00);
        this.tree.setLayoutData(data);
        this.loadDocTypes();
        this.editDocTypeBtn = new Button(this, 8);
        this.editDocTypeBtn.setText("Edit type");
        this.editDocTypeBtn.setEnabled(false);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(this.addNewDocTypeBtn, 0);
        data.left = new FormAttachment(this.tree, 10);
        this.editDocTypeBtn.setLayoutData(data);
        this.removeDocTypeBtn = new Button(this, 8);
        this.removeDocTypeBtn.setText("Remove type");
        this.removeDocTypeBtn.setEnabled(false);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(this.editDocTypeBtn, 0);
        data.left = new FormAttachment(this.tree, 10);
        this.removeDocTypeBtn.setLayoutData(data);
        this.addMetadataBtn = new Button(this, 8);
        this.addMetadataBtn.setText("Add new metadata");
        this.addMetadataBtn.setEnabled(false);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(this.removeDocTypeBtn, 0);
        data.left = new FormAttachment(this.tree, 10);
        this.addMetadataBtn.setLayoutData(data);
        this.editMetadataBtn = new Button(this, 8);
        this.editMetadataBtn.setText("Edit metadata");
        this.editMetadataBtn.setEnabled(false);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(this.addMetadataBtn, 0);
        data.left = new FormAttachment(this.tree, 10);
        this.editMetadataBtn.setLayoutData(data);
        this.removeMetadataBtn = new Button(this, 8);
        this.removeMetadataBtn.setText("Remove metadata");
        this.removeMetadataBtn.setEnabled(false);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(this.editMetadataBtn, 0);
        data.left = new FormAttachment(this.tree, 10);
        this.removeMetadataBtn.setLayoutData(data);
        this.doneBtn = new Button(this, 8);
        this.doneBtn.setText("Done");
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(this.tree, 0, 1024);
        data.left = new FormAttachment(this.tree, 10);
        this.doneBtn.setLayoutData(data);
        this.addEventListeners();
    }

    private void addEventListeners() {
        this.tree.addListener(36, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                TreeItem parent = item.getParentItem();
                DocumentType parentDT = (DocumentType)parent.getData("docType");
                parent.setText(parentDT.getTypeName());
                DefaultMetadata[] metadata = (DefaultMetadata[])parent.getData("metadata");
                if (metadata == null && parentDT.getDefaultMetadataCollection().size() > 0) {
                    metadata = parentDT.getDefaultMetadataCollection().toArray(new DefaultMetadata[0]);
                    parent.setData("metadata", metadata);
                }
                if (metadata != null) {
                    DefaultMetadata currentMeta = metadata[e.index];
                    item.setText(DocTypeEditor.this.getMetadataItemLabel(currentMeta));
                    item.setData("metadataObject", currentMeta);
                    item.setImage(new Image(null, "images/info.png"));
                }
            }
        });
        this.tree.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                if (item == null) {
                    return;
                }
                if (item.getParentItem() == null) {
                    DocTypeEditor.this.removeDocTypeBtn.setEnabled(true);
                    DocTypeEditor.this.editDocTypeBtn.setEnabled(true);
                    DocTypeEditor.this.removeMetadataBtn.setEnabled(false);
                    DocTypeEditor.this.addMetadataBtn.setEnabled(true);
                    DocTypeEditor.this.editMetadataBtn.setEnabled(false);
                } else {
                    DocTypeEditor.this.removeDocTypeBtn.setEnabled(true);
                    DocTypeEditor.this.editDocTypeBtn.setEnabled(true);
                    DocTypeEditor.this.removeMetadataBtn.setEnabled(true);
                    DocTypeEditor.this.addMetadataBtn.setEnabled(true);
                    DocTypeEditor.this.editMetadataBtn.setEnabled(true);
                }
            }
        });
        this.addMetadataBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem item = DocTypeEditor.this.getDTParentOfSelection();
                DocumentType dt = (DocumentType)item.getData("docType");
                MetadataDialog dialog = new MetadataDialog();
                dialog.showAndHandle(DocTypeEditor.this.getShell(), dt, null);
                try {
                    DocumentType type = Application.getBll().getDocumentType(dt.getId());
                    item.setItemCount(type.getDefaultMetadataCollection().size());
                    item.setData("metadata", type.getDefaultMetadataCollection().toArray(new DefaultMetadata[0]));
                    item.setData("docType", type);
                    DocTypeEditor.this.tree.redraw();
                    item.setExpanded(true);
                }
                catch (UnknownDocumentTypeException e1) {
                    NotificationWindow.showError("Unknwon document type", "Failed to load the document type from the database.");
                }
            }
        });
        this.editMetadataBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem metadataItem = DocTypeEditor.this.tree.getSelection()[0];
                DefaultMetadata metadataObject = (DefaultMetadata)metadataItem.getData("metadataObject");
                if (metadataObject != null) {
                    DefaultMetadata currentMeta = metadataObject;
                    TreeItem item = DocTypeEditor.this.getDTParentOfSelection();
                    TreeItem selectedItem = DocTypeEditor.this.tree.getSelection()[0];
                    DocumentType dt = (DocumentType)item.getData("docType");
                    MetadataDialog dialog = new MetadataDialog();
                    currentMeta = dialog.showAndHandle(DocTypeEditor.this.getShell(), dt, currentMeta);
                    selectedItem.setText(DocTypeEditor.this.getMetadataItemLabel(currentMeta));
                    selectedItem.setData("metadataObject", currentMeta);
                    try {
                        DocumentType type = Application.getBll().getDocumentType(dt.getId());
                        item.setItemCount(type.getDefaultMetadataCollection().size());
                        item.setData("metadata", type.getDefaultMetadataCollection().toArray(new DefaultMetadata[0]));
                        item.setData("docType", type);
                        DocTypeEditor.this.tree.redraw();
                        item.setExpanded(true);
                    }
                    catch (UnknownDocumentTypeException e1) {
                        NotificationWindow.showError("Unknwon document type", "Failed to load the document type from the database.");
                    }
                } else {
                    NotificationWindow.showError("Error", "Failed to load the metadata object from database.");
                }
            }
        });
        this.addNewDocTypeBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentTypeDialog dialog = new DocumentTypeDialog();
                DocumentType newType = dialog.showAndHandle(DocTypeEditor.this.getShell(), null);
                if (newType != null) {
                    DocTypeEditor.this.addDocTypeToTree(newType);
                }
            }
        });
        this.editDocTypeBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentTypeDialog dialog = new DocumentTypeDialog();
                TreeItem item = DocTypeEditor.this.getDTParentOfSelection();
                DocumentType dt = (DocumentType)item.getData("docType");
                dialog.showAndHandle(DocTypeEditor.this.getShell(), dt);
                item.setText(dt.getTypeName());
            }
        });
        this.removeDocTypeBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem item = DocTypeEditor.this.getDTParentOfSelection();
                DocumentType dt = (DocumentType)item.getData("docType");
                Application.getBll().removeDocumentType(dt.getId());
                item.dispose();
            }
        });
        this.removeMetadataBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                TreeItem item = DocTypeEditor.this.tree.getSelection()[0];
                DefaultMetadata metadataObject = (DefaultMetadata)item.getData("metadataObject");
                Application.getBll().removeDefaultMetadata(metadataObject.getId());
                item.dispose();
            }
        });
        this.doneBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                if (DocTypeEditor.this.previous != null) {
                    ViewManager.getDefault().showView(DocTypeEditor.this.previous);
                }
            }
        });
    }

    private void loadDocTypes() {
        Collection<DocumentType> docTypes = Application.getBll().getAllDocumentTypes();
        for (DocumentType d : docTypes) {
            this.addDocTypeToTree(d);
        }
    }

    private void addDocTypeToTree(DocumentType d) {
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText(d.getTypeName());
        int metadataCount = d.getDefaultMetadataCollection().size();
        item.setImage(new Image(null, "images/document.png"));
        item.setData(d);
        item.setData("docType", d);
        item.setItemCount(metadataCount);
    }

    private TreeItem getDTParentOfSelection() {
        TreeItem item = this.tree.getSelection()[0];
        while (item.getParentItem() != null) {
            item = item.getParentItem();
        }
        return item;
    }

    private String getMetadataItemLabel(DefaultMetadata currentMeta) {
        String dv = "";
        if (currentMeta.getValue() != null && !currentMeta.getValue().isEmpty()) {
            dv = " (" + currentMeta.getValue() + ")";
        }
        return String.valueOf(currentMeta.getName()) + " : " + (Object)((Object)currentMeta.getMetadataType()) + dv;
    }

    @Override
    public void showed() {
        if (this.previous != null) {
            this.doneBtn.setVisible(true);
        } else {
            this.doneBtn.setVisible(false);
        }
        super.showed();
    }
}

