/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.doctype;

import hu.documaison.Application;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.gui.ImageHelper;
import hu.documaison.gui.NotificationWindow;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DocumentTypeDialog {
    private Composite composite;
    private Button saveBtn;
    private Text nameText;
    private Shell dialog;
    private Text extText;
    private Button browseThumbnail;
    private Canvas thumbnailImage;
    private DocumentType previousType;
    private byte[] thumbBytes;

    public DocumentType showAndHandle(Shell parent, DocumentType previousType) {
        this.previousType = previousType;
        this.dialog = new Shell(parent, 67680);
        if (previousType == null) {
            this.dialog.setText("Add new document type");
        } else {
            this.dialog.setText("Edit document type");
        }
        this.dialog.setLayout(new FillLayout());
        this.composite = new Composite(this.dialog, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        this.composite.setLayout(gridLayout);
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText("Document type name:");
        this.nameText = new Text(this.composite, 2048);
        if (previousType != null) {
            this.nameText.setText(previousType.getTypeName());
        }
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.nameText.setLayoutData(gridData);
        Label typeLabel = new Label(this.composite, 0);
        typeLabel.setText("Default type for extensions:");
        this.extText = new Text(this.composite, 2048);
        if (previousType != null) {
            this.extText.setText(previousType.getDefaultExt());
        }
        this.extText.setMessage("Format: doc, docx, ...");
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.extText.setLayoutData(gridData);
        Label thumbnailLabel = new Label(this.composite, 0);
        thumbnailLabel.setText("Default thumbnail:");
        this.thumbnailImage = new Canvas(this.composite, 0);
        if (previousType != null && previousType.getDefaultThumbnailBytes() != null) {
            this.thumbBytes = previousType.getDefaultThumbnailBytes();
            BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(previousType.getDefaultThumbnailBytes()));
            ImageData imageData = new ImageData(inputStreamReader);
            Image byteImage = new Image((Device)parent.getDisplay(), imageData);
            ImageHelper.setResizedBackground(this.thumbnailImage, byteImage);
        } else {
            try {
                this.storeNewThumbnail("images/unknown.png");
            }
            catch (IOException e) {
                NotificationWindow.showError("Error", "Can't load default thumbnail");
            }
        }
        gridData = new GridData();
        gridData.verticalSpan = 2;
        this.thumbnailImage.setLayoutData(gridData);
        this.browseThumbnail = new Button(this.composite, 8);
        this.browseThumbnail.setText("Browse");
        this.saveBtn = new Button(this.composite, 8);
        this.saveBtn.setText("Save");
        this.saveBtn.setEnabled(false);
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.saveBtn.setLayoutData(gridData);
        this.addEventHandlers();
        this.validateInputs();
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.previousType;
    }

    private void addEventHandlers() {
        this.saveBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentType dt = null;
                if (DocumentTypeDialog.this.previousType != null) {
                    dt = DocumentTypeDialog.this.previousType;
                } else {
                    try {
                        dt = Application.getBll().createDocumentType();
                    }
                    catch (UnableToCreateException e1) {
                        NotificationWindow.showError("Database error", "Unable to create new document type. (" + e1.getMessage() + ")");
                    }
                    DocumentTypeDialog.this.previousType = dt;
                }
                dt.setDefaultExt(DocumentTypeDialog.this.extText.getText());
                dt.setTypeName(DocumentTypeDialog.this.nameText.getText());
                dt.setDefaultThumbnailBytes(DocumentTypeDialog.this.thumbBytes);
                Application.getBll().updateDocumentType(dt);
                DocumentTypeDialog.this.dialog.dispose();
            }
        });
        this.browseThumbnail.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setText("Select thumbnail");
                dialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.bmp", "*.gif"});
                String path = dialog.open();
                if (path != null) {
                    try {
                        DocumentTypeDialog.this.storeNewThumbnail(path);
                    }
                    catch (IOException e1) {
                        NotificationWindow.showError("I/O error", e1.getMessage());
                    }
                }
                DocumentTypeDialog.this.validateInputs();
            }
        });
        this.nameText.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentTypeDialog.this.validateInputs();
            }
        });
        this.extText.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentTypeDialog.this.validateInputs();
            }
        });
    }

    private byte[] storeNewThumbnail(String path) throws IOException {
        this.thumbBytes = ImageHelper.getImageBytes(path);
        BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(this.thumbBytes));
        ImageData imageData = new ImageData(inputStreamReader);
        Image byteImage = new Image(null, imageData);
        ImageHelper.setResizedBackground(this.thumbnailImage, byteImage);
        return this.thumbBytes;
    }

    private void validateInputs() {
        if (this.nameText.getText().isEmpty()) {
            this.saveBtn.setEnabled(false);
        } else if (!this.extText.getText().isEmpty()) {
            if (!this.extText.getText().matches("(\\w*(, *)?)+")) {
                this.saveBtn.setEnabled(false);
            } else {
                this.saveBtn.setEnabled(true);
            }
        } else {
            this.saveBtn.setEnabled(true);
        }
    }
}

