/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.doctype;

import hu.documaison.Application;
import hu.documaison.data.entities.DefaultMetadata;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.MetadataType;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.gui.NotificationWindow;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MetadataDialog {
    private Control c;
    private Combo typeCombo;
    private Composite composite;
    private Button saveBtn;
    private DocumentType parentType;
    private Text nameText;
    private Shell dialog;
    private DefaultMetadata metadata;

    public DefaultMetadata showAndHandle(Shell parent, DocumentType docType, DefaultMetadata metadata) {
        this.parentType = docType;
        this.metadata = metadata;
        this.dialog = new Shell(parent, 67680);
        this.dialog.setText("Add new metadata");
        this.dialog.setLayout(new FillLayout());
        this.composite = new Composite(this.dialog, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        this.composite.setLayout(gridLayout);
        Label lab1 = new Label(this.composite, 0);
        lab1.setText("Adding new metadata for:");
        Label lab2 = new Label(this.composite, 0);
        lab2.setText(docType.getTypeName());
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText("Metadata name:");
        this.nameText = new Text(this.composite, 2048);
        if (metadata != null) {
            this.nameText.setText(metadata.getName());
        }
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.nameText.setLayoutData(gridData);
        Label typeLabel = new Label(this.composite, 0);
        typeLabel.setText("Metadata type:");
        this.typeCombo = new Combo(this.composite, 12);
        MetadataType[] values = MetadataType.values();
        int i = 0;
        while (i < values.length) {
            MetadataType metadataType = values[i];
            this.typeCombo.add("" + (Object)((Object)metadataType));
            if (metadata != null && metadata.getMetadataType() == metadataType) {
                this.typeCombo.select(i);
            }
            ++i;
        }
        if (metadata == null) {
            this.typeCombo.select(0);
        }
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.typeCombo.setLayoutData(gridData);
        Label dvLabel = new Label(this.composite, 0);
        dvLabel.setText("Default value:");
        if (metadata == null) {
            this.c = this.createOneField(this.composite, this.typeCombo.getItem(0), null);
        } else {
            switch (metadata.getMetadataType()) {
                case Date: {
                    this.c = this.createOneField(this.composite, "Date", metadata.getDateValue());
                    break;
                }
                case Integer: {
                    this.c = this.createOneField(this.composite, "Integer", metadata.getValue());
                    break;
                }
                case Text: {
                    this.c = this.createOneField(this.composite, "Text", metadata.getValue());
                    break;
                }
                default: {
                    this.c = this.createOneField(this.composite, "Text", metadata.getValue());
                }
            }
        }
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.c.setLayoutData(gridData);
        this.saveBtn = new Button(this.composite, 8);
        this.saveBtn.setText("Save");
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.saveBtn.setLayoutData(gridData);
        this.addEventHandlers();
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return metadata;
    }

    private Control createOneField(Composite parent, String type, Object value) {
        if (type.equalsIgnoreCase("Text")) {
            Text textField = new Text(parent, 2048);
            if (value != null) {
                textField.setText((String)value);
            }
            return textField;
        }
        if (type.equalsIgnoreCase("Integer")) {
            Text textField = new Text(parent, 2048);
            if (value != null) {
                textField.setText((String)value);
            }
            return textField;
        }
        if (type.equalsIgnoreCase("Date")) {
            DateTime dateField = new DateTime(parent, 65572);
            if (value != null) {
                Date valueD = (Date)value;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(valueD);
                dateField.setDate(cal.get(1), cal.get(2), cal.get(5));
            }
            return dateField;
        }
        NotificationWindow.showError("Internal error", "Unknown metadata type, can't create field for " + type + ".");
        Text textField = new Text(parent, 2048);
        return textField;
    }

    private void addEventHandlers() {
        this.typeCombo.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                Control old = MetadataDialog.this.c;
                MetadataDialog.this.c = MetadataDialog.this.createOneField(MetadataDialog.this.composite, MetadataDialog.this.typeCombo.getItem(MetadataDialog.this.typeCombo.getSelectionIndex()), null);
                GridData gridData = new GridData(4, 4, true, false);
                gridData.widthHint = 300;
                MetadataDialog.this.c.setLayoutData(gridData);
                MetadataDialog.this.c.moveAbove(old);
                old.dispose();
                MetadataDialog.this.composite.layout();
            }
        });
        this.saveBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                block12: {
                    if (MetadataDialog.this.metadata == null) {
                        try {
                            MetadataDialog.this.metadata = Application.getBll().createDefaultMetadata(MetadataDialog.this.parentType);
                        }
                        catch (UnableToCreateException e1) {
                            NotificationWindow.showError("Database error", "Unable to create metadata entry, the changes are not saved!");
                            return;
                        }
                    }
                    MetadataDialog.this.metadata.setName(MetadataDialog.this.nameText.getText());
                    String typeName = MetadataDialog.this.typeCombo.getItem(MetadataDialog.this.typeCombo.getSelectionIndex());
                    MetadataType[] values = MetadataType.values();
                    int i = 0;
                    while (i < values.length) {
                        MetadataType metadataType = values[i];
                        if (typeName.equalsIgnoreCase("" + (Object)((Object)metadataType))) {
                            MetadataDialog.this.metadata.setMetadataType(metadataType);
                        }
                        ++i;
                    }
                    if (MetadataDialog.this.c instanceof Text) {
                        Text text = (Text)MetadataDialog.this.c;
                        try {
                            if (text.getText().isEmpty()) break block12;
                            if (MetadataDialog.this.metadata.getMetadataType() == MetadataType.Integer) {
                                MetadataDialog.this.metadata.setValue(Integer.parseInt(text.getText()));
                                break block12;
                            }
                            MetadataDialog.this.metadata.setValue(text.getText());
                        }
                        catch (Exception ex) {
                            NotificationWindow.showError("Conversion error", "Failed to convert data");
                        }
                    } else if (MetadataDialog.this.c instanceof DateTime) {
                        DateTime dt = (DateTime)MetadataDialog.this.c;
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.set(dt.getYear(), dt.getMonth(), dt.getDay());
                        MetadataDialog.this.metadata.setValue(cal.getTime());
                    } else {
                        NotificationWindow.showError("Conversion error", "Can't handle the selected metadata type");
                    }
                }
                Application.getBll().updateDefaultMetadata(MetadataDialog.this.metadata);
                MetadataDialog.this.dialog.dispose();
            }
        });
    }
}

