/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.document;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.helper.DataHelper;
import hu.documaison.data.helper.FileHelper;
import hu.documaison.gui.ImageHelper;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.document.DocumentLister;
import hu.documaison.gui.document.DocumentObserver;
import hu.documaison.gui.document.IDocumentChangeListener;
import hu.documaison.gui.metadataPanel.MetadataEditors;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DocumentItem
extends Composite
implements IDocumentChangeListener,
MouseListener {
    private final Composite parent;
    private Canvas thumbnailImage;
    private Label titleLabel;
    private Label authorLabel;
    private final Color selectionBackground = new Color(null, 189, 210, 238);
    private MetadataEditors editor;
    private Document doc;
    private DocumentLister lister;
    private Button openButton;
    private Button otherActions;
    private MenuItem openFolder;
    private MenuItem delItem;
    private MenuItem copyItem;
    private MenuItem moveItem;
    private MenuItem copyBibTex;

    public DocumentItem(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new FormLayout());
        this.parent = parent;
        this.createComposites();
    }

    private void createComposites() {
        this.thumbnailImage = new Canvas(this, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 30);
        data.width = 50;
        data.height = 60;
        this.thumbnailImage.setLayoutData(data);
        this.openButton = new Button(this, 8);
        this.openButton.setText("Open");
        Image openImage = new Image(null, "images/open.png");
        this.openButton.setImage(openImage);
        data = new FormData();
        data.top = new FormAttachment(this.thumbnailImage, 0, 0x1000000);
        data.right = new FormAttachment(100, -70);
        data.height = 45;
        this.openButton.setLayoutData(data);
        this.otherActions = new Button(this, 8);
        data = new FormData();
        data.top = new FormAttachment(this.thumbnailImage, 0, 0x1000000);
        data.left = new FormAttachment(this.openButton, 2);
        data.height = 45;
        data.width = 30;
        this.otherActions.setLayoutData(data);
        Image downArrowImage = new Image(null, "images/down_arrow.png");
        this.otherActions.setImage(downArrowImage);
        this.titleLabel = new Label(this, 0);
        FontData[] fontData = this.titleLabel.getFont().getFontData();
        fontData[0].setHeight(14);
        fontData[0].setStyle(1);
        data = new FormData();
        data.top = new FormAttachment(0, 20);
        data.left = new FormAttachment(this.thumbnailImage, 10);
        data.right = new FormAttachment(this.openButton, -10);
        this.titleLabel.setFont(new Font(null, fontData[0]));
        this.titleLabel.setLayoutData(data);
        this.authorLabel = new Label(this, 0);
        data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 10);
        data.left = new FormAttachment(this.thumbnailImage, 10);
        data.right = new FormAttachment(this.openButton, -10);
        this.authorLabel.setLayoutData(data);
        fontData = this.authorLabel.getFont().getFontData();
        fontData[0].setStyle(2);
        this.authorLabel.setFont(new Font(null, fontData[0]));
        this.addEventListeners();
    }

    public void setDocument(Document document) {
        if (this.doc != document) {
            if (this.doc != null) {
                DocumentObserver.detach(this.doc.getId(), this);
            }
            DocumentObserver.attach(document.getId(), this);
        }
        try {
            this.doc = Application.getBll().getDocument(document.getId());
        }
        catch (UnknownDocumentException e) {
            NotificationWindow.showError("DB error", "Can't update document data");
        }
        if (this.editor.isShowed(this.doc)) {
            this.setSelection(true, false);
        } else {
            this.setSelection(false, false);
        }
        if (document.getThumbnailBytes() != null) {
            BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(document.getThumbnailBytes()));
            ImageData imageData = new ImageData(inputStreamReader);
            Image byteImage = new Image((Device)this.parent.getDisplay(), imageData);
            ImageHelper.setResizedBackground(this.thumbnailImage, byteImage);
        } else {
            ImageHelper.setResizedBackground(this.thumbnailImage, new Image((Device)this.getDisplay(), "images/unknown.png"));
        }
        this.loadOtherCommands();
        Metadata title = this.doc.getMetadata("title");
        if (title == null) {
            title = this.doc.getMetadata("Title");
        }
        if (title == null || title.getValue() == null) {
            if (this.doc.getLocation() != null) {
                if (DataHelper.isURL(this.doc.getLocation())) {
                    this.titleLabel.setText(this.doc.getLocation());
                } else {
                    this.titleLabel.setText(FileHelper.fileName(this.doc.getLocation()));
                }
            } else {
                this.titleLabel.setText("Untitled document");
            }
        } else {
            this.titleLabel.setText(title.getValue());
        }
        Metadata author = this.doc.getMetadata("author");
        if (author == null) {
            author = this.doc.getMetadata("Author");
        }
        if (author == null || author.getValue() == null) {
            this.authorLabel.setText("Unknown author");
        } else {
            this.authorLabel.setText(author.getValue());
        }
    }

    private void addEventListeners() {
        this.addMouseListener(this);
        if (this.thumbnailImage != null) {
            this.thumbnailImage.addMouseListener(this);
        }
        this.titleLabel.addMouseListener(this);
        this.authorLabel.addMouseListener(this);
        this.openButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (DocumentItem.this.getDoc().getLocation() != null) {
                    Program.launch(DocumentItem.this.getDoc().getLocation());
                } else {
                    NotificationWindow.showError("Database error", "The location is a null value in the database.");
                }
            }
        });
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(150, 80, changed);
    }

    public void setSelection(boolean selection, boolean nomore) {
        if (selection) {
            this.setBackground(this.selectionBackground);
            if (this.doc != null && !this.editor.isShowed(this.getDoc())) {
                this.editor.showDoc(this);
            }
            this.lister.setDetailsVisible(true);
        } else {
            if (nomore) {
                this.editor.setHidden();
                this.lister.setDetailsVisible(false);
            }
            this.setBackground(null);
        }
    }

    public void setEditor(MetadataEditors editor) {
        this.editor = editor;
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setLister(DocumentLister lister) {
        this.lister = lister;
    }

    @Override
    public void setBackground(Color c) {
        this.titleLabel.setBackground(c);
        this.authorLabel.setBackground(c);
        this.thumbnailImage.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void documentChanged() {
        this.setDocument(this.doc);
    }

    @Override
    public void mouseDoubleClick(MouseEvent arg0) {
    }

    @Override
    public void mouseDown(MouseEvent arg0) {
        this.setSelection(!this.editor.isShowed(this.doc), true);
    }

    @Override
    public void mouseUp(MouseEvent arg0) {
    }

    public void copyBibTex(Document doc) {
        Clipboard cb = new Clipboard(this.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{DataHelper.createBibTex(doc)}, new Transfer[]{textTransfer});
    }

    private void loadOtherCommands() {
        final Menu dropMenu = new Menu(this.getShell(), 8);
        this.getShell().setMenu(dropMenu);
        this.openFolder = new MenuItem(dropMenu, 8);
        this.openFolder.setText("Open containing folder");
        this.delItem = new MenuItem(dropMenu, 8);
        this.delItem.setText("Remove document");
        this.moveItem = new MenuItem(dropMenu, 8);
        this.moveItem.setText("Relocate document");
        this.copyItem = new MenuItem(dropMenu, 8);
        this.copyItem.setText("Export document");
        new MenuItem(dropMenu, 2);
        this.copyBibTex = new MenuItem(dropMenu, 8);
        this.copyBibTex.setText("Copy BibTeX");
        String location = this.getDoc().getLocation();
        if (location == null || DataHelper.isURL(location)) {
            this.openFolder.setEnabled(false);
            this.moveItem.setEnabled(false);
            this.copyItem.setEnabled(false);
        }
        this.addOtherEventListeners();
        this.otherActions.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (dropMenu != null && !dropMenu.isVisible()) {
                    Rectangle bounds = button.getBounds();
                    Point menuLoc = button.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                    dropMenu.setLocation(menuLoc.x, menuLoc.y);
                    dropMenu.setVisible(true);
                }
            }
        });
    }

    private void addOtherEventListeners() {
        this.copyBibTex.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DocumentItem.this.copyBibTex(DocumentItem.this.getDoc());
            }
        });
        this.copyItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(DocumentItem.this.getShell());
                dialog.setText("Export directory");
                String path = dialog.open();
                if (path != null) {
                    try {
                        String fileName = FileHelper.fileName(DocumentItem.this.doc.getLocation());
                        Application.getBll().copyDocument(DocumentItem.this.doc, String.valueOf(path) + File.separator + fileName);
                        Program.launch(path);
                    }
                    catch (Exception e1) {
                        NotificationWindow.showError("Copy error", "Failed to export the selected document. (" + e1.getMessage() + ")");
                    }
                }
            }
        });
        this.moveItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(DocumentItem.this.getShell());
                dialog.setText("New directory");
                String path = dialog.open();
                if (path != null) {
                    try {
                        String fileName = FileHelper.fileName(DocumentItem.this.doc.getLocation());
                        Application.getBll().moveDocument(DocumentItem.this.doc, String.valueOf(path) + File.separator + fileName);
                    }
                    catch (Exception e1) {
                        NotificationWindow.showError("Copy error", "Failed to export the selected document. (" + e1.getMessage() + ")");
                    }
                }
            }
        });
        this.delItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    if (DocumentItem.this.doc.getLocation() == null || DocumentItem.this.doc.getLocation().isEmpty() || DataHelper.isURL(DocumentItem.this.doc.getLocation())) {
                        Application.getBll().removeDocument(DocumentItem.this.doc.getId());
                    } else {
                        Application.getBll().deleteAndRemoveDocument(DocumentItem.this.doc);
                    }
                }
                catch (UnknownDocumentException e1) {
                    NotificationWindow.showError("Error", "Can't locate the document. (" + e1.getMessage() + ")");
                }
                catch (InvalidParameterException e1) {
                    NotificationWindow.showError("Error", "Can't delete the document. (" + e1.getMessage() + ")");
                }
                DocumentObserver.notifyLister();
            }
        });
        this.openFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DocumentItem.this.openContainingFolder(DocumentItem.this.getDoc());
            }
        });
    }

    private void openContainingFolder(Document doc) {
        if (doc.getLocation() != null || !DataHelper.isURL(doc.getLocation())) {
            File f = new File(doc.getLocation());
            if (!f.exists()) {
                NotificationWindow.showError("Error", "The file does not exist.");
            } else {
                Program.launch(f.getParent());
            }
        }
    }

    @Override
    public void dispose() {
        System.out.println("Disposing item");
        if (this.editor.isShowed(this.doc)) {
            this.lister.setDetailsVisible(false);
        }
        DocumentObserver.detach(this.doc.getId(), this);
        super.dispose();
    }
}

