/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.document;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.search.SearchExpression;
import hu.documaison.gui.ITagSelectionChangeListener;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.commentstags.TagPanel;
import hu.documaison.gui.document.DocumentItem;
import hu.documaison.gui.document.DocumentObserver;
import hu.documaison.gui.metadataPanel.MetadataEditors;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class DocumentLister
extends InnerPanel
implements ITagSelectionChangeListener,
IRowContentProvider {
    private ArrayList<Document> documents;
    private Sash sash;
    private boolean sashVisible = false;
    private CompositeTable table;
    private Composite panel;
    private Label label;
    private MetadataEditors editor;
    private boolean showAll = true;
    private SearchExpression searchExpression;
    private String searchString;
    private final HashMap<Integer, DocumentItem> itemMap = new HashMap();

    public DocumentLister(Composite parent, int style) {
        super(parent, style, "Documents");
    }

    @Override
    protected void createComposite() {
        DocumentObserver.setLister(this);
        this.sash = new Sash(this, 65792);
        TagPanel.addChangeListener(this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(100, 0);
        this.sash.setLayoutData(data);
        this.sash.setBackground(new Color(null, 84, 84, 84));
        this.sash.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                int limit = 200;
                if (!DocumentLister.this.sashVisible) {
                    limit = 0;
                }
                if (DocumentLister.this.getBounds().height - e.y < limit) {
                    e.y = DocumentLister.this.getBounds().height - limit;
                }
                DocumentLister.this.sash.setBounds(e.x, e.y, e.width, e.height);
                FormData formData = new FormData();
                formData.top = new FormAttachment(100, -1 * (DocumentLister.this.getBounds().height - e.y));
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                DocumentLister.this.sash.setLayoutData(formData);
                DocumentLister.this.layout(true);
            }
        });
        this.sash.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
                DocumentLister.this.setDetailsVisible(false);
            }
        });
        this.panel = new Composite(this, 0);
        this.panel.setLayout(new FillLayout());
        data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(this.sash, 0);
        this.panel.setLayoutData(data);
        this.editor = new MetadataEditors(this, 0, this);
        data = new FormData();
        data.top = new FormAttachment(this.sash, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, 0);
        this.editor.setLayoutData(data);
    }

    @Override
    public void showed() {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>(Application.getBll().getDocuments());
        }
        if (this.documents.size() == 0) {
            if (this.table != null) {
                this.table.dispose();
                this.table = null;
            }
            if (this.label == null) {
                this.label = new Label(this.panel, 64);
                this.label.setText("  No document found in the database for the current selection.");
            }
        } else {
            if (this.label != null) {
                this.label.dispose();
                this.label = null;
            }
            if (this.table != null && !this.table.isDisposed()) {
                this.table.dispose();
            }
            this.setDetailsVisible(false);
            DocumentObserver.detachAllDocumentItem();
            this.table = new CompositeTable(this.panel, 0);
            this.itemMap.clear();
            DocumentItem it = new DocumentItem(this.table, 0);
            this.table.setBackground(it.getBackground());
            this.table.setRunTime(true);
            this.table.setNumRowsInCollection(this.documents.size());
            this.table.removeRowContentProvider(this);
            this.table.addRowContentProvider(this);
        }
        this.panel.layout();
        super.showed();
    }

    public void setDetailsVisible(boolean visible) {
        if (visible && this.sashVisible || !visible && !this.sashVisible) {
            return;
        }
        if (visible) {
            this.sashVisible = true;
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(100, -200);
            this.sash.setLayoutData(data);
        } else {
            this.sashVisible = false;
            this.editor.setHidden();
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(100, 0);
            this.sash.setLayoutData(data);
        }
        this.layout();
    }

    public void freetextSearch(String freetext) {
        this.showAll = false;
        this.searchString = freetext;
        this.searchExpression = null;
        this.documents = new ArrayList<Document>(Application.getBll().searchDocumentsFreeText(freetext));
        if (freetext.equalsIgnoreCase("t\u00fcpt\u00fcr\u00fcpp")) {
            NotificationWindow.showError("Easter egg", "Cipciripp");
        }
    }

    public void showAll() {
        this.documents = new ArrayList<Document>(Application.getBll().getDocuments());
        this.showAll = true;
    }

    public void advancedSearch(SearchExpression expression) {
        this.showAll = false;
        this.searchString = null;
        this.searchExpression = expression;
        this.documents = new ArrayList<Document>(Application.getBll().searchDocuments(expression));
    }

    @Override
    public void selectionChanged() {
        if (TagPanel.isSelectionEmpty()) {
            this.showAll();
        } else {
            System.out.println("Search started");
            this.documents = new ArrayList<Document>(Application.getBll().getDocumentsByTags(TagPanel.getSelection()));
            System.out.println("And it's done");
        }
        this.showed();
    }

    public void notifyLister() {
        this.setDetailsVisible(false);
        if (this.showAll) {
            this.showAll();
        } else if (this.searchString != null) {
            this.freetextSearch(this.searchString);
        } else if (this.searchExpression != null) {
            this.advancedSearch(this.searchExpression);
        } else {
            this.showAll = true;
            this.searchExpression = null;
            this.searchString = null;
            this.showAll();
        }
        this.showed();
    }

    @Override
    public void refresh(CompositeTable sender, int currentObjectOffset, Control rowControl) {
        DocumentItem row = (DocumentItem)rowControl;
        row.setEditor(this.editor);
        row.setLister(this);
        Document documentToShow = this.documents.get(currentObjectOffset);
        row.setDocument(documentToShow);
        this.itemMap.put(documentToShow.getId(), row);
    }

    public DocumentItem getItemForDocument(int ID) {
        return this.itemMap.get(ID);
    }
}

