/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.document;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.ViewManager;
import hu.documaison.gui.document.DocumentObserver;
import hu.documaison.gui.metadataPanel.MetadataEditors;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class MetadataInputPanel
extends InnerPanel {
    private Document documentToEdit = null;
    private Label infoLabel;
    private MetadataEditors editors;

    public MetadataInputPanel(Composite parent, int style) {
        super(parent, style, "Edit document metadata");
    }

    @Override
    protected void createComposite() {
        this.infoLabel = new Label(this, 64);
        this.infoLabel.setText("Edit the document's metadata. You can also add and remove any metadata entry.");
        FormData data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(0, 20);
        this.infoLabel.setLayoutData(data);
        Button saveBtn = new Button(this, 8);
        saveBtn.setText("Save document");
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.right = new FormAttachment(100, -10);
        saveBtn.setLayoutData(data);
        Button cancelBtn = new Button(this, 8);
        cancelBtn.setText("Cancel");
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.right = new FormAttachment(saveBtn, -10);
        cancelBtn.setLayoutData(data);
        this.editors = new MetadataEditors(this, 0, null);
        data = new FormData();
        data.top = new FormAttachment(this.infoLabel, 5);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(100, -20);
        data.bottom = new FormAttachment(100, -50);
        this.editors.setLayoutData(data);
        saveBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DocumentObserver.notifyLister();
                ViewManager.getDefault().showView("documents");
            }
        });
        cancelBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                Application.getBll().removeDocument(MetadataInputPanel.this.documentToEdit.getId());
                ViewManager.getDefault().showView("documents");
            }
        });
    }

    public void setDocument(Document doc) {
        this.documentToEdit = doc;
        this.editors.showDoc(doc);
        this.layout();
    }
}

