/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.document;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.data.exceptions.UnknownDocumentTypeException;
import hu.documaison.data.helper.DataHelper;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.ViewManager;
import hu.documaison.gui.document.MetadataInputPanel;
import java.io.File;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewDocumentPanel
extends InnerPanel {
    private Link typeLink;
    private Combo typeCombo;
    private Button nextBtn;
    private Text locText;
    private HashMap<String, Integer> typeIdMap;
    private Button browseButton;
    private Button cancelBtn;

    public NewDocumentPanel(Composite parent, int style) {
        super(parent, style, "Add new document");
    }

    @Override
    protected void createComposite() {
        Label locLabel = new Label(this, 0);
        locLabel.setText("Document location (file or URL):");
        FormData data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(100, -20);
        locLabel.setLayoutData(data);
        this.browseButton = new Button(this, 8);
        this.browseButton.setText("Browse");
        data = new FormData();
        data.top = new FormAttachment(locLabel);
        data.right = new FormAttachment(100, -20);
        this.browseButton.setLayoutData(data);
        this.locText = new Text(this, 2048);
        data = new FormData();
        data.top = new FormAttachment(this.browseButton, 0, 0x1000000);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(this.browseButton);
        this.locText.setLayoutData(data);
        Label hintLabel = new Label(this, 64);
        hintLabel.setText("The document location shall be an absolute path in case of a local files or an URL, started with \"http://\" in case of remote documents.");
        FontData[] fD = hintLabel.getFont().getFontData();
        fD[0].setHeight(10);
        hintLabel.setFont(new Font((Device)this.getDisplay(), fD[0]));
        data = new FormData();
        data.top = new FormAttachment(this.locText, 10);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(this.browseButton);
        hintLabel.setLayoutData(data);
        Label typeLabel = new Label(this, 0);
        typeLabel.setText("Document type:");
        data = new FormData();
        data.top = new FormAttachment(hintLabel, 20);
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(100, -20);
        typeLabel.setLayoutData(data);
        this.typeCombo = new Combo(this, 12);
        this.loadDocTypes();
        data = new FormData();
        data.top = new FormAttachment(typeLabel, 0);
        data.left = new FormAttachment(0, 20);
        data.width = 150;
        this.typeCombo.setLayoutData(data);
        this.typeLink = new Link(this, 0);
        this.typeLink.setText("<a>Manage document types</a>");
        data = new FormData();
        data.top = new FormAttachment(this.typeCombo, 0, 0x1000000);
        data.left = new FormAttachment(this.typeCombo, 10);
        this.typeLink.setLayoutData(data);
        this.nextBtn = new Button(this, 8);
        this.nextBtn.setText("Next");
        this.nextBtn.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment(this.typeCombo, 30);
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, -100);
        this.nextBtn.setLayoutData(data);
        this.cancelBtn = new Button(this, 8);
        this.cancelBtn.setText("Cancel");
        data = new FormData();
        data.top = new FormAttachment(this.typeCombo, 30);
        data.right = new FormAttachment(this.nextBtn, -10);
        this.cancelBtn.setLayoutData(data);
        this.addEventListeners();
    }

    private void addEventListeners() {
        this.typeLink.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                ViewManager.getDefault().showView("doctypeeditor", NewDocumentPanel.this);
            }
        });
        this.typeCombo.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                NewDocumentPanel.this.validate();
            }
        });
        this.locText.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event e) {
                NewDocumentPanel.this.validate();
            }
        });
        this.nextBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    Document doc = Application.getBll().createDocument((Integer)NewDocumentPanel.this.typeIdMap.get(NewDocumentPanel.this.typeCombo.getItem(NewDocumentPanel.this.typeCombo.getSelectionIndex())));
                    doc.setLocation(NewDocumentPanel.this.locText.getText());
                    MetadataInputPanel panel = (MetadataInputPanel)ViewManager.getDefault().showView("metaedit", NewDocumentPanel.this);
                    Application.getBll().updateDocument(doc);
                    panel.setDocument(doc);
                }
                catch (UnknownDocumentTypeException e1) {
                    NotificationWindow.showError("Unknown type", "Failed to load the definition of the selected type. (" + e1.getMessage() + ")");
                }
                catch (UnableToCreateException e1) {
                    NotificationWindow.showError("Database error", "Unable to create new document. (" + e1.getMessage() + ")");
                }
            }
        });
        this.browseButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(NewDocumentPanel.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.*"});
                String path = dialog.open();
                if (path != null) {
                    NewDocumentPanel.this.locText.setText(path);
                }
            }
        });
        this.cancelBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                ViewManager.getDefault().showView("documents");
            }
        });
    }

    @Override
    public void showed() {
        this.locText.setText("");
        this.loadDocTypes();
        this.layout();
        this.validate();
        super.showed();
    }

    private void loadDocTypes() {
        this.typeCombo.removeAll();
        this.typeIdMap = new HashMap();
        for (DocumentType dt : Application.getBll().getDocumentTypes()) {
            this.typeCombo.add(dt.getTypeName());
            this.typeIdMap.put(dt.getTypeName(), dt.getId());
        }
    }

    private void validate() {
        File f;
        this.nextBtn.setEnabled(false);
        if (!this.locText.getText().isEmpty() && ((f = new File(this.locText.getText())).exists() || DataHelper.isURL(this.locText.getText())) && this.typeCombo.getSelectionIndex() != -1) {
            this.nextBtn.setEnabled(true);
        }
    }
}

