/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.metadataPanel;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.entities.MetadataType;
import hu.documaison.data.exceptions.UnableToCreateException;
import hu.documaison.gui.NotificationWindow;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddMoreMetadataDialog {
    private Control c;
    private Combo typeCombo;
    private Composite composite;
    private Button saveBtn;
    private Document parentDoc;
    private Text nameText;
    private Shell dialog;
    private Metadata metadata;

    public Metadata showAndHandle(Shell parent, Document doc) {
        this.parentDoc = doc;
        this.dialog = new Shell(parent, 67680);
        this.dialog.setText("Add more metadata");
        this.dialog.setLayout(new FillLayout());
        this.composite = new Composite(this.dialog, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        this.composite.setLayout(gridLayout);
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText("Metadata name:");
        this.nameText = new Text(this.composite, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.nameText.setLayoutData(gridData);
        Label typeLabel = new Label(this.composite, 0);
        typeLabel.setText("Metadata type:");
        this.typeCombo = new Combo(this.composite, 12);
        MetadataType[] values = MetadataType.values();
        int i = 0;
        while (i < values.length) {
            MetadataType metadataType = values[i];
            this.typeCombo.add("" + (Object)((Object)metadataType));
            ++i;
        }
        this.typeCombo.select(0);
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.typeCombo.setLayoutData(gridData);
        Label dvLabel = new Label(this.composite, 0);
        dvLabel.setText("Value:");
        this.c = this.createOneField(this.composite, this.typeCombo.getItem(0), null);
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.c.setLayoutData(gridData);
        this.saveBtn = new Button(this.composite, 8);
        this.saveBtn.setText("Add");
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.saveBtn.setLayoutData(gridData);
        this.addEventHandlers();
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.metadata;
    }

    private Control createOneField(Composite parent, String type, Object value) {
        if (type.equalsIgnoreCase("Text")) {
            Text textField = new Text(parent, 2048);
            if (value != null) {
                textField.setText((String)value);
            }
            return textField;
        }
        if (type.equalsIgnoreCase("Integer")) {
            Text textField = new Text(parent, 2048);
            if (value != null) {
                textField.setText((String)value);
            }
            return textField;
        }
        if (type.equalsIgnoreCase("Date")) {
            DateTime dateField = new DateTime(parent, 65572);
            if (value != null) {
                Date valueD = (Date)value;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(valueD);
                dateField.setDate(cal.get(1), cal.get(2), cal.get(5));
            }
            return dateField;
        }
        NotificationWindow.showError("Internal error", "Unknown metadata type, can't create field for " + type + ".");
        Text textField = new Text(parent, 2048);
        return textField;
    }

    private void addEventHandlers() {
        this.typeCombo.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                Control old = AddMoreMetadataDialog.this.c;
                AddMoreMetadataDialog.this.c = AddMoreMetadataDialog.this.createOneField(AddMoreMetadataDialog.this.composite, AddMoreMetadataDialog.this.typeCombo.getItem(AddMoreMetadataDialog.this.typeCombo.getSelectionIndex()), null);
                GridData gridData = new GridData(4, 4, true, false);
                gridData.widthHint = 300;
                AddMoreMetadataDialog.this.c.setLayoutData(gridData);
                AddMoreMetadataDialog.this.c.moveAbove(old);
                old.dispose();
                AddMoreMetadataDialog.this.composite.layout();
            }
        });
        this.saveBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                block11: {
                    try {
                        AddMoreMetadataDialog.this.metadata = Application.getBll().createMetadata(AddMoreMetadataDialog.this.parentDoc);
                    }
                    catch (UnableToCreateException e1) {
                        NotificationWindow.showError("Database error", "Unable to create metadata entry, the changes are not saved!");
                        return;
                    }
                    AddMoreMetadataDialog.this.metadata.setName(AddMoreMetadataDialog.this.nameText.getText());
                    String typeName = AddMoreMetadataDialog.this.typeCombo.getItem(AddMoreMetadataDialog.this.typeCombo.getSelectionIndex());
                    MetadataType[] values = MetadataType.values();
                    int i = 0;
                    while (i < values.length) {
                        MetadataType metadataType = values[i];
                        if (typeName.equalsIgnoreCase("" + (Object)((Object)metadataType))) {
                            AddMoreMetadataDialog.this.metadata.setMetadataType(metadataType);
                        }
                        ++i;
                    }
                    if (AddMoreMetadataDialog.this.c instanceof Text) {
                        Text text = (Text)AddMoreMetadataDialog.this.c;
                        try {
                            if (text.getText().isEmpty()) break block11;
                            if (AddMoreMetadataDialog.this.metadata.getMetadataType() == MetadataType.Integer) {
                                AddMoreMetadataDialog.this.metadata.setValue(Integer.parseInt(text.getText()));
                                break block11;
                            }
                            AddMoreMetadataDialog.this.metadata.setValue(text.getText());
                        }
                        catch (Exception ex) {
                            NotificationWindow.showError("Conversion error", "Failed to convert data");
                        }
                    } else if (AddMoreMetadataDialog.this.c instanceof DateTime) {
                        DateTime dt = (DateTime)AddMoreMetadataDialog.this.c;
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.set(dt.getYear(), dt.getMonth(), dt.getDay());
                        AddMoreMetadataDialog.this.metadata.setValue(cal.getTime());
                    } else {
                        NotificationWindow.showError("Conversion error", "Can't handle the selected metadata type");
                    }
                }
                Application.getBll().updateMetadata(AddMoreMetadataDialog.this.metadata);
                AddMoreMetadataDialog.this.dialog.dispose();
            }
        });
    }
}

