/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.metadataPanel;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.gui.ImageHelper;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.commentstags.CommentDialog;
import hu.documaison.gui.commentstags.TagViewer;
import hu.documaison.gui.document.DocumentObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class MainDetailsPanel
extends Composite {
    private final Link commentLink;
    private final Document document;
    private final Label tagLabel;
    private TagViewer tags;
    private final Canvas thumbnailImage;
    private final Button browseThumbnail;
    private final Combo typeCombo;
    private final HashMap<Integer, DocumentType> doctypemap = new HashMap();

    public MainDetailsPanel(Composite parent, int style, Document doc) {
        super(parent, style);
        this.document = doc;
        this.setLayout(new FormLayout());
        Label typeLabel = new Label(this, 0);
        typeLabel.setText("Document type:");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment(0, 0);
        typeLabel.setLayoutData(data);
        this.typeCombo = new Combo(this, 12);
        int id = 0;
        int i = 0;
        for (DocumentType dt : Application.getBll().getDocumentTypes()) {
            this.typeCombo.add(dt.getTypeName());
            if (dt.getTypeName().equalsIgnoreCase(doc.getType().getTypeName())) {
                id = i;
            }
            this.doctypemap.put(i, dt);
            ++i;
        }
        this.typeCombo.select(id);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(typeLabel, 5);
        this.typeCombo.setLayoutData(data);
        this.commentLink = new Link(this, 0);
        this.commentLink.setText("<a>Comments...</a>");
        data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment(this.typeCombo, 10);
        this.commentLink.setLayoutData(data);
        this.thumbnailImage = new Canvas(this, 0);
        this.thumbnailImage.setBackground(this.getBackground());
        if (doc.getThumbnailBytes() != null) {
            BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(doc.getThumbnailBytes()));
            ImageData imageData = new ImageData(inputStreamReader);
            Image byteImage = new Image((Device)parent.getDisplay(), imageData);
            ImageHelper.setResizedBackground(this.thumbnailImage, byteImage);
        } else {
            ImageHelper.setResizedBackground(this.thumbnailImage, new Image((Device)Display.getDefault(), "images/unknown.png"));
        }
        data = new FormData();
        data.left = new FormAttachment(typeLabel, 5);
        data.top = new FormAttachment(this.typeCombo, 5);
        data.width = 50;
        data.height = 60;
        this.thumbnailImage.setLayoutData(data);
        Label thumbnailLabel = new Label(this, 0);
        thumbnailLabel.setText("Thumbnail:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(this.typeCombo, 5);
        thumbnailLabel.setLayoutData(data);
        this.browseThumbnail = new Button(this, 8);
        this.browseThumbnail.setText("Change");
        data = new FormData();
        data.left = new FormAttachment(thumbnailLabel, 0, 0x1000000);
        data.top = new FormAttachment(thumbnailLabel, 5);
        this.browseThumbnail.setLayoutData(data);
        this.tagLabel = new Label(this, 0);
        this.tagLabel.setText("Tags:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(this.thumbnailImage, -15);
        this.tagLabel.setLayoutData(data);
        this.showTags(doc);
        this.addEventHandlers();
    }

    private void addEventHandlers() {
        this.commentLink.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                CommentDialog dialog = new CommentDialog();
                dialog.showAndHandle(MainDetailsPanel.this.getShell(), MainDetailsPanel.this.document);
                Application.getBll().updateDocument(MainDetailsPanel.this.document);
            }
        });
        this.browseThumbnail.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setText("Select thumbnail");
                dialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.bmp", "*.gif"});
                String path = dialog.open();
                if (path != null) {
                    try {
                        byte[] thumb = MainDetailsPanel.this.storeNewThumbnail(path);
                        MainDetailsPanel.this.document.setThumbnailBytes(thumb);
                        Application.getBll().updateDocument(MainDetailsPanel.this.document);
                        DocumentObserver.notify(MainDetailsPanel.this.document.getId(), null);
                    }
                    catch (IOException e) {
                        NotificationWindow.showError("Error", "Failed to load resource:" + e.getMessage());
                    }
                }
            }
        });
        this.typeCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    Application.getBll().changeDocumentType(MainDetailsPanel.this.document, (DocumentType)MainDetailsPanel.this.doctypemap.get(MainDetailsPanel.this.typeCombo.getSelectionIndex()));
                }
                catch (Exception e1) {
                    NotificationWindow.showError("DB error", "Failed to change document type (" + e1.getMessage() + ")");
                }
                DocumentObserver.notify(MainDetailsPanel.this.document.getId(), null);
            }
        });
    }

    private void showTags(Document doc) {
        if (this.tags != null) {
            this.tags.dispose();
        }
        this.tags = new TagViewer(this, 0);
        this.tags.createControls(doc);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(this.tagLabel, 0);
        data.right = new FormAttachment(100, -10);
        this.tags.setLayoutData(data);
        this.layout();
    }

    @Override
    public void dispose() {
        if (this.tags != null) {
            this.tags.dispose();
        }
        super.dispose();
    }

    private byte[] storeNewThumbnail(String path) throws IOException {
        byte[] thumbBytes = ImageHelper.getImageBytes(path);
        BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(thumbBytes));
        ImageData imageData = new ImageData(inputStreamReader);
        Image byteImage = new Image(null, imageData);
        ImageHelper.setResizedBackground(this.thumbnailImage, byteImage);
        return thumbBytes;
    }
}

