/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.metadataPanel;

import hu.documaison.data.entities.Document;
import hu.documaison.gui.document.DocumentItem;
import hu.documaison.gui.document.DocumentLister;
import hu.documaison.gui.metadataPanel.MainDetailsPanel;
import hu.documaison.gui.metadataPanel.MetadataPanel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;

public class MetadataEditors
extends Composite {
    private MainDetailsPanel mainPanel;
    private MetadataPanel morePanel;
    private Document document;
    private DocumentItem item;
    private final DocumentLister lister;

    public MetadataEditors(Composite parent, int style, DocumentLister lister) {
        super(parent, style);
        this.lister = lister;
        this.setLayout(new FormLayout());
    }

    public void showDoc(Document doc) {
        if (this.mainPanel != null) {
            this.mainPanel.dispose();
        }
        if (this.morePanel != null) {
            this.morePanel.dispose();
        }
        this.document = doc;
        this.mainPanel = new MainDetailsPanel(this, 0, doc);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(50, 0);
        data.bottom = new FormAttachment(100, 0);
        this.mainPanel.setLayoutData(data);
        this.morePanel = new MetadataPanel(this, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(50, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.morePanel.setLayoutData(data);
        this.morePanel.setDocument(doc);
        this.layout();
    }

    public boolean isShowed(Document doc) {
        if (doc == null || this.document == null) {
            return false;
        }
        if (doc.getId() == this.document.getId()) {
            this.document = doc;
            return true;
        }
        return false;
    }

    public void showDoc(DocumentItem documentItem) {
        if (this.item != null && this.item != documentItem) {
            if (this.item.isDisposed()) {
                this.item = null;
            } else {
                DocumentItem itemToUnselect = this.lister.getItemForDocument(this.document.getId());
                itemToUnselect.setSelection(false, false);
            }
        }
        this.showDoc(documentItem.getDoc());
        this.item = documentItem;
    }

    public void setHidden() {
        this.document = null;
        this.item = null;
    }
}

