/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.metadataPanel;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.helper.DataHelper;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.document.DocumentObserver;
import hu.documaison.gui.document.IDocumentChangeListener;
import hu.documaison.gui.metadataPanel.AddMoreMetadataDialog;
import hu.documaison.gui.metadataPanel.RemoveMetadataDialog;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTPropertyChangeListener;
import org.mihalis.opal.propertyTable.PropertyTable;
import org.mihalis.opal.propertyTable.editor.PTDateEditor;
import org.mihalis.opal.propertyTable.editor.PTFileEditor;
import org.mihalis.opal.propertyTable.editor.PTIntegerEditor;
import org.mihalis.opal.propertyTable.editor.PTStringEditor;
import org.mihalis.opal.propertyTable.editor.PTURLEditor;

public class MetadataPanel
extends Composite
implements IDocumentChangeListener {
    private PropertyTable pTable;
    private final Link addProp;
    private Document doc;
    private HashMap<String, Metadata> metadataMap;
    private final Link remProp;
    private Timer timer;
    private TimerTask timerTask;
    private final Composite parent;

    public MetadataPanel(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.setLayout(new FormLayout());
        this.addProp = new Link(this, 0);
        this.addProp.setText("<a>Add more metadata...</a>");
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, -5);
        data.right = new FormAttachment(100, -10);
        this.addProp.setLayoutData(data);
        this.addProp.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AddMoreMetadataDialog dialog = new AddMoreMetadataDialog();
                Metadata metadata = dialog.showAndHandle(MetadataPanel.this.getShell(), MetadataPanel.this.doc);
                try {
                    MetadataPanel.this.doc = Application.getBll().getDocument(MetadataPanel.this.doc.getId());
                }
                catch (UnknownDocumentException e1) {
                    NotificationWindow.showError("Database error", "Failed to update document from database.");
                }
                if (metadata != null) {
                    DocumentObserver.notify(MetadataPanel.this.doc.getId(), null);
                }
            }
        });
        this.remProp = new Link(this, 0);
        this.remProp.setText("<a>Remove metadata</a>");
        data = new FormData();
        data.bottom = new FormAttachment(100, -5);
        data.right = new FormAttachment(this.addProp, -5);
        this.remProp.setLayoutData(data);
        this.remProp.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                RemoveMetadataDialog dialog = new RemoveMetadataDialog();
                dialog.showAndHandle(MetadataPanel.this.getShell(), MetadataPanel.this.doc);
                DocumentObserver.notify(MetadataPanel.this.doc.getId(), null);
            }
        });
    }

    public void setDocument(Document doc) {
        if (this.doc != null && this.doc != doc) {
            DocumentObserver.detach(this.doc.getId(), this);
        }
        if (this.doc != doc) {
            DocumentObserver.attach(doc.getId(), this);
        }
        this.doc = doc;
        this.createNewPropTable();
        this.addProperties();
        this.pack();
        this.layout(true);
    }

    private void createNewPropTable() {
        if (this.pTable != null) {
            this.pTable.dispose();
        }
        this.pTable = new PropertyTable(this, 2048);
        FormData data = new FormData();
        data.bottom = new FormAttachment(this.addProp, -5);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.pTable.setLayoutData(data);
        this.pTable.viewAsFlatList();
        this.pTable.hideButtons();
        this.pTable.hideDescription();
        this.pTable.addChangeListener(new PTPropertyChangeListener(){

            @Override
            public void propertyHasChanged(PTProperty prop) {
                if (!prop.getDisplayName().equalsIgnoreCase("loc")) {
                    Metadata mtdt = (Metadata)MetadataPanel.this.metadataMap.get(prop.getDisplayName());
                    switch (mtdt.getMetadataType()) {
                        case Date: {
                            mtdt.setValue((Date)prop.getValue());
                            break;
                        }
                        case Integer: {
                            mtdt.setValue((Integer)prop.getValue());
                            break;
                        }
                        default: {
                            mtdt.setValue((String)prop.getValue());
                        }
                    }
                    MetadataPanel.this.lazyUpdate(MetadataPanel.this.doc, mtdt);
                }
            }
        });
    }

    private void addProp(Metadata mtdt) {
        this.metadataMap.put("" + mtdt.getId(), mtdt);
        switch (mtdt.getMetadataType()) {
            case Date: {
                if (this.pTable.getProperties().containsKey(mtdt.getName())) break;
                this.pTable.addProperty(new PTProperty(mtdt.getName(), "" + mtdt.getId(), null, mtdt.getDateValue()).setEditor(new PTDateEditor()));
                break;
            }
            case Integer: {
                if (this.pTable.getProperties().containsKey(mtdt.getName())) break;
                this.pTable.addProperty(new PTProperty(mtdt.getName(), "" + mtdt.getId(), null, mtdt.getIntValue()).setEditor(new PTIntegerEditor()));
                break;
            }
            default: {
                if (this.pTable.getProperties().containsKey(mtdt.getName())) break;
                this.pTable.addProperty(new PTProperty(mtdt.getName(), "" + mtdt.getId(), null, mtdt.getValue()).setEditor(new PTStringEditor()));
            }
        }
    }

    @Override
    public void documentChanged() {
        this.createNewPropTable();
        this.addProperties();
        this.pack();
        this.parent.layout();
    }

    private void addProperties() {
        try {
            this.doc = Application.getBll().getDocument(this.doc.getId());
        }
        catch (UnknownDocumentException e) {
            NotificationWindow.showError("DB error", "Failed to update the document from db.");
        }
        String loc = this.doc.getLocation();
        if (loc != null) {
            if (DataHelper.isURL(loc)) {
                this.pTable.addProperty(new PTProperty("Location (URL)", "loc", "", loc).setEditor(new PTURLEditor()));
            } else {
                this.pTable.addProperty(new PTProperty("Location (file)", "loc", "", loc).setEditor(new PTFileEditor()));
            }
        }
        this.metadataMap = new HashMap();
        if (this.doc.getMetadataCollection() != null) {
            for (Metadata mtdt : this.doc.getMetadataCollection()) {
                this.addProp(mtdt);
            }
        }
    }

    private void lazyUpdate(final Document doc, final Metadata mtdt) {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.timerTask == null || this.timerTask.scheduledExecutionTime() < new Date().getTime()) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    Application.getBll().updateMetadata(mtdt);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("Runned");
                            DocumentObserver.notify(doc.getId(), MetadataPanel.this);
                        }
                    });
                }
            };
            this.timer.schedule(this.timerTask, 300L);
            System.out.println("Scheduled");
        }
    }

    @Override
    public void dispose() {
        DocumentObserver.detach(this.doc.getId(), this);
        super.dispose();
    }
}

