/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.metadataPanel;

import hu.documaison.Application;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.Metadata;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RemoveMetadataDialog {
    private Document parentDoc;
    private Shell dialog;
    private Button removeBtn;
    private Combo metadataCombo;
    private ArrayList<Metadata> metadataList;

    public void showAndHandle(Shell parent, Document doc) {
        this.parentDoc = doc;
        this.metadataList = new ArrayList<Metadata>(doc.getMetadataCollection());
        this.dialog = new Shell(parent, 67680);
        this.dialog.setText("Select metadata to remove");
        this.dialog.setLayout(new FillLayout());
        Composite composite = new Composite(this.dialog, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout(gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Metadata name:");
        this.metadataCombo = new Combo(composite, 12);
        this.loadMetadataCombo(doc);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        this.metadataCombo.setLayoutData(gridData);
        this.removeBtn = new Button(composite, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.setEnabled(false);
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.removeBtn.setLayoutData(gridData);
        this.addEventHandlers();
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void loadMetadataCombo(Document doc) {
        for (Metadata m : this.metadataList) {
            this.metadataCombo.add(m.getName());
        }
    }

    private void addEventHandlers() {
        this.metadataCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (RemoveMetadataDialog.this.metadataCombo.getSelectionIndex() > -1) {
                    RemoveMetadataDialog.this.removeBtn.setEnabled(true);
                } else {
                    RemoveMetadataDialog.this.removeBtn.setEnabled(false);
                }
            }
        });
        this.removeBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Metadata mtdt = (Metadata)RemoveMetadataDialog.this.metadataList.get(RemoveMetadataDialog.this.metadataCombo.getSelectionIndex());
                RemoveMetadataDialog.this.parentDoc.removeMetadata(mtdt);
                Application.getBll().updateDocument(RemoveMetadataDialog.this.parentDoc);
                RemoveMetadataDialog.this.dialog.dispose();
            }
        });
    }
}

