/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.search;

import hu.documaison.Application;
import hu.documaison.data.entities.AbstractMetadata;
import hu.documaison.data.entities.MetadataType;
import hu.documaison.data.helper.MetadataNameTypePair;
import hu.documaison.data.search.Operator;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.gui.search.SearchField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AdvancedSearchField
extends Composite {
    private final Combo choices;
    private final HashMap<String, SearchField> searchFieldCache = new HashMap();
    private final ArrayList<SearchField> searchFields = new ArrayList();
    private final Combo fieldName;
    private final Button removeBtn;
    private final Button addBtn;
    private Control input1 = null;
    private Control input2 = null;

    public AdvancedSearchField(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new FormLayout());
        this.fieldName = new Combo(this, 12);
        int count = this.loadSearchFields(Application.getBll().getAllMetadataKeys());
        SearchField selectedSF = null;
        if (count > 0) {
            this.fieldName.select(0);
            selectedSF = this.searchFields.get(0);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.bottom = new FormAttachment(100, -3);
        data.left = new FormAttachment(0, 10);
        this.fieldName.setLayoutData(data);
        this.choices = new Combo(this, 12);
        if (selectedSF != null) {
            this.loadChoices(selectedSF.getType());
            this.choices.select(0);
        }
        data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.bottom = new FormAttachment(100, -3);
        data.left = new FormAttachment(this.fieldName, 10);
        this.choices.setLayoutData(data);
        this.addBtn = new Button(this, 8);
        this.addBtn.setText("+");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, -10);
        this.addBtn.setLayoutData(data);
        this.removeBtn = new Button(this, 8);
        this.removeBtn.setText("-");
        this.removeBtn.setVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(this.addBtn, 0);
        this.removeBtn.setLayoutData(data);
        if (selectedSF != null) {
            this.loadInputFields(false, selectedSF.getType());
        }
        this.createEventHandlers();
    }

    private void loadChoices(MetadataType type) {
        this.choices.removeAll();
        if (type == MetadataType.Text) {
            this.choices.add("contains:");
            this.choices.add("not contains:");
            this.choices.add("equals:");
            this.choices.add("not equals:");
            this.choices.add("starts with:");
            this.choices.add("ends with:");
        } else if (type == MetadataType.Integer) {
            this.choices.add("equals:");
            this.choices.add("not equals:");
            this.choices.add("less than:");
            this.choices.add("more than:");
            this.choices.add("in between:");
        } else if (type == MetadataType.Date) {
            this.choices.add("equals:");
            this.choices.add("not equals:");
            this.choices.add("in between:");
        }
        this.choices.select(0);
        this.loadInputsForSelection();
    }

    private int loadSearchFields(Collection<MetadataNameTypePair> metadata) {
        for (MetadataNameTypePair m : metadata) {
            SearchField sf = new SearchField(m.getName(), m.getType());
            this.searchFieldCache.put(m.getName(), sf);
            this.fieldName.add(sf.getName());
            this.searchFields.add(sf);
        }
        return this.searchFields.size();
    }

    private void loadInputFields(boolean isMultiple, MetadataType type) {
        if (this.input1 != null) {
            this.input1.dispose();
        }
        if (this.input2 != null) {
            this.input2.dispose();
        }
        if (!isMultiple) {
            this.input1 = this.createOneField(type);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 3);
            data.bottom = new FormAttachment(100, -3);
            data.left = new FormAttachment(this.choices, 10);
            data.right = new FormAttachment(this.removeBtn, -15);
            this.input1.setLayoutData(data);
        } else {
            this.input1 = this.createOneField(type);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 3);
            data.bottom = new FormAttachment(100, -3);
            data.left = new FormAttachment(this.choices, 10);
            data.width = 150;
            this.input1.setLayoutData(data);
            this.input2 = this.createOneField(type);
            data = new FormData();
            data.top = new FormAttachment(0, 3);
            data.bottom = new FormAttachment(100, -3);
            data.left = new FormAttachment(this.input1, 10);
            data.width = 150;
            this.input2.setLayoutData(data);
        }
        this.layout();
    }

    private Control createOneField(MetadataType type) {
        if (type == MetadataType.Text) {
            Text textField = new Text(this, 2048);
            return textField;
        }
        if (type == MetadataType.Integer) {
            Text textField = new Text(this, 2048);
            return textField;
        }
        if (type == MetadataType.Date) {
            DateTime dateField = new DateTime(this, 65572);
            return dateField;
        }
        NotificationWindow.showError("Internal error", "Unknown metadata type, can't create search field");
        Text textField = new Text(this, 2048);
        return textField;
    }

    private void createEventHandlers() {
        this.fieldName.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (AdvancedSearchField.this.fieldName.getSelectionIndex() < 0) {
                    AdvancedSearchField.this.choices.removeAll();
                } else {
                    SearchField selected = (SearchField)AdvancedSearchField.this.searchFieldCache.get(AdvancedSearchField.this.fieldName.getItem(AdvancedSearchField.this.fieldName.getSelectionIndex()));
                    AdvancedSearchField.this.loadChoices(selected.getType());
                }
            }
        });
        this.choices.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (AdvancedSearchField.this.choices.getSelectionIndex() >= 0) {
                    AdvancedSearchField.this.loadInputsForSelection();
                }
            }
        });
    }

    public void addPlusListener(SelectionListener listener) {
        this.addBtn.addSelectionListener(listener);
    }

    public void setRemoveVisibility(boolean visibility) {
        this.removeBtn.setVisible(visibility);
    }

    public void addRemoveListener(SelectionListener listener) {
        this.removeBtn.addSelectionListener(listener);
    }

    private void loadInputsForSelection() {
        if (this.choices.getItem(this.choices.getSelectionIndex()).equalsIgnoreCase("in between:")) {
            SearchField selected = this.searchFieldCache.get(this.fieldName.getItem(this.fieldName.getSelectionIndex()));
            this.loadInputFields(true, selected.getType());
        } else {
            SearchField selected = this.searchFieldCache.get(this.fieldName.getItem(this.fieldName.getSelectionIndex()));
            this.loadInputFields(false, selected.getType());
        }
    }

    public String getSelectedMetadataName() {
        return this.fieldName.getItem(this.fieldName.getSelectionIndex());
    }

    public Operator getOperator() {
        String operatorString = this.choices.getItem(this.choices.getSelectionIndex());
        if (operatorString.equalsIgnoreCase("contains:")) {
            return Operator.contains;
        }
        if (operatorString.equals("not contains:")) {
            return Operator.notcontains;
        }
        if (operatorString.equals("equals:")) {
            return Operator.eq;
        }
        if (operatorString.equals("not equals:")) {
            return Operator.neq;
        }
        if (operatorString.equals("starts with:")) {
            return Operator.like;
        }
        if (operatorString.equals("ends with:")) {
            return Operator.like;
        }
        if (operatorString.equals("less than:")) {
            return Operator.lt;
        }
        if (operatorString.equals("more than:")) {
            return Operator.gt;
        }
        if (operatorString.equals("in between:")) {
            return Operator.between;
        }
        throw new UnsupportedOperationException("Unknown operator: '" + operatorString + "'.");
    }

    public String getValue1() {
        if (this.input1 == null) {
            throw new IllegalArgumentException("Can't load first input of " + this.getSelectedMetadataName() + " field.");
        }
        if (this.input1 instanceof Text) {
            Text inputText = (Text)this.input1;
            String operatorString = this.choices.getItem(this.choices.getSelectionIndex());
            if (operatorString.equalsIgnoreCase("starts with:")) {
                return String.valueOf(inputText.getText()) + "%";
            }
            if (operatorString.equalsIgnoreCase("ends with:")) {
                return "%" + inputText.getText();
            }
            return inputText.getText();
        }
        if (this.input1 instanceof DateTime) {
            DateTime inputDateTime = (DateTime)this.input1;
            GregorianCalendar inputCal = new GregorianCalendar(inputDateTime.getYear(), inputDateTime.getMonth(), inputDateTime.getDay());
            return AbstractMetadata.DATEFORMAT.format(inputCal.getTime());
        }
        throw new UnsupportedOperationException("Can't handle input for " + this.getSelectedMetadataName() + " field.");
    }

    public String getValue2() {
        if (this.input2 == null) {
            throw new IllegalArgumentException("Can't load first input of " + this.getSelectedMetadataName() + " field.");
        }
        if (this.input2 instanceof Text) {
            Text inputText = (Text)this.input2;
            String operatorString = this.choices.getItem(this.choices.getSelectionIndex());
            if (operatorString.equalsIgnoreCase("starts with:")) {
                return "%" + inputText.getText();
            }
            if (operatorString.equalsIgnoreCase("ends with:")) {
                return String.valueOf(inputText.getText()) + "%";
            }
            return inputText.getText();
        }
        if (this.input2 instanceof DateTime) {
            DateTime inputDateTime = (DateTime)this.input2;
            GregorianCalendar inputCal = new GregorianCalendar(inputDateTime.getYear(), inputDateTime.getMonth(), inputDateTime.getDay());
            return AbstractMetadata.DATEFORMAT.format(inputCal.getTime());
        }
        throw new UnsupportedOperationException("Can't handle input for " + this.getSelectedMetadataName() + " field.");
    }

    public void reset() {
        this.loadInputsForSelection();
    }
}

