/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.search;

import hu.documaison.Application;
import hu.documaison.data.search.BoolOperator;
import hu.documaison.data.search.SearchExpression;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.ViewManager;
import hu.documaison.gui.document.DocumentLister;
import hu.documaison.gui.search.AdvancedSearchField;
import hu.documaison.gui.search.SearchExpressionBuilder;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class AdvancedSearchPanel
extends InnerPanel {
    private AdvancedSearchField firstSearch;
    private ArrayList<AdvancedSearchField> searchFields;
    private Label operator1;
    private Combo operatorCombo;
    private Button searchButton;
    private Button cancelButton;

    public AdvancedSearchPanel(Composite parent, int style) {
        super(parent, style, "Advanced search");
    }

    @Override
    protected void createComposite() {
        this.searchFields = new ArrayList();
        this.operator1 = new Label(this, 0);
        this.operator1.setText("The following filters will be used, with an");
        FormData data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(0, 10);
        this.operator1.setLayoutData(data);
        this.operatorCombo = new Combo(this, 12);
        data = new FormData();
        data.top = new FormAttachment(this.operator1, 0, 0x1000000);
        data.left = new FormAttachment(this.operator1, 5);
        this.operatorCombo.setLayoutData(data);
        this.operatorCombo.add("AND");
        this.operatorCombo.add("OR");
        this.operatorCombo.select(0);
        Label operator2 = new Label(this, 0);
        operator2.setText("operator:");
        data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 25);
        data.left = new FormAttachment(this.operatorCombo, 5);
        operator2.setLayoutData(data);
        this.firstSearch = new AdvancedSearchField(this, 0);
        data = new FormData();
        data.top = new FormAttachment(this.operator1, 25);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.firstSearch.setLayoutData(data);
        this.searchFields.add(this.firstSearch);
        this.searchButton = new Button(this, 8);
        this.searchButton.setText("Search");
        data = new FormData();
        data.bottom = new FormAttachment(100, -30);
        data.right = new FormAttachment(100, -50);
        this.searchButton.setLayoutData(data);
        this.cancelButton = new Button(this, 8);
        this.cancelButton.setText("Cancel");
        data = new FormData();
        data.bottom = new FormAttachment(100, -30);
        data.right = new FormAttachment(this.searchButton, -10);
        this.cancelButton.setLayoutData(data);
        this.addEventListeners();
    }

    private void clearAll() {
    }

    private void addEventListeners() {
        this.item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AdvancedSearchPanel.this.clearAll();
            }
        });
        this.firstSearch.addPlusListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                final AdvancedSearchField asf = new AdvancedSearchField(AdvancedSearchPanel.this, 0);
                FormData data = new FormData();
                AdvancedSearchField last = (AdvancedSearchField)AdvancedSearchPanel.this.searchFields.get(AdvancedSearchPanel.this.searchFields.size() - 1);
                data.top = new FormAttachment(last, 0);
                data.left = new FormAttachment(0, 5);
                data.right = new FormAttachment(100, -5);
                asf.setLayoutData(data);
                AdvancedSearchPanel.this.searchFields.add(asf);
                AdvancedSearchPanel.this.layout();
                asf.addPlusListener(this);
                asf.addRemoveListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        AdvancedSearchPanel.this.removeListener(asf);
                    }
                });
                AdvancedSearchPanel.this.checkRemoveBtns();
            }
        });
        this.firstSearch.addRemoveListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AdvancedSearchPanel.this.removeListener(AdvancedSearchPanel.this.firstSearch);
            }
        });
        this.searchButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SearchExpression expr = SearchExpressionBuilder.createExpression(AdvancedSearchPanel.this.searchFields, AdvancedSearchPanel.this.getBoolOperator());
                DocumentLister lister = (DocumentLister)ViewManager.getDefault().getView("documents");
                lister.advancedSearch(expr);
                ViewManager.getDefault().showView(lister);
            }
        });
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DocumentLister lister = (DocumentLister)ViewManager.getDefault().getView("documents");
                lister.showAll();
                ViewManager.getDefault().showView(lister);
            }
        });
    }

    private void checkRemoveBtns() {
        if (this.searchFields.size() > 1) {
            for (AdvancedSearchField field : this.searchFields) {
                field.setRemoveVisibility(true);
            }
        } else {
            for (AdvancedSearchField field : this.searchFields) {
                field.setRemoveVisibility(false);
            }
        }
    }

    private void removeListener(AdvancedSearchField field) {
        Control next = null;
        AdvancedSearchField prev = null;
        int i = 0;
        while (i < this.searchFields.size() - 1) {
            if (this.searchFields.get(i) == field) {
                next = this.searchFields.get(i + 1);
                if (i > 0) {
                    prev = this.searchFields.get(i - 1);
                }
            }
            ++i;
        }
        if (next != null) {
            FormData data = (FormData)next.getLayoutData();
            data.top = prev != null ? new FormAttachment(prev, 0) : new FormAttachment(this.operator1, 25);
        }
        this.searchFields.remove(field);
        field.dispose();
        this.checkRemoveBtns();
        this.layout();
    }

    private BoolOperator getBoolOperator() {
        if (this.operatorCombo.getItem(this.operatorCombo.getSelectionIndex()).equalsIgnoreCase("and")) {
            return BoolOperator.and;
        }
        return BoolOperator.or;
    }

    @Override
    public void showed() {
        if (Application.getBll().getAllMetadataKeys().size() == 0) {
            ViewManager.getDefault().showView("documents");
        } else {
            int i = this.searchFields.size() - 1;
            while (i > 0) {
                this.removeListener(this.searchFields.get(i));
                --i;
            }
            this.searchFields.get(0).reset();
        }
    }
}

