/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.gui.settings;

import hu.documaison.Application;
import hu.documaison.gui.InnerPanel;
import hu.documaison.gui.NotificationWindow;
import hu.documaison.indexing.AutomaticIndexing;
import hu.documaison.indexing.IndexerFactory;
import hu.documaison.settings.SettingsData;
import hu.documaison.settings.SettingsManager;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SettingsPanel
extends InnerPanel {
    private Button addFolderBtn;
    private Button removeFolderBtn;
    private List indexingFolders;
    private Button browseBtn;
    private Text dbText;
    private Button indexingCheck;
    private Label indexingLabel;

    public SettingsPanel(Composite parent, int style) {
        super(parent, style, "Settings");
    }

    @Override
    protected void createComposite() {
        SettingsData settings = new SettingsData();
        try {
            settings = SettingsManager.getCurrentSettings();
        }
        catch (Exception e) {
            NotificationWindow.showError("File error", "Failed to load the application's settings.");
        }
        this.indexingCheck = new Button(this, 32);
        this.indexingCheck.setText("Enable automatic indexing of documents. Manual refresh can be done from the File menu anytime.");
        this.indexingCheck.setSelection(settings.isIndexingEnabled());
        FormData data = new FormData();
        data.top = new FormAttachment(this.titleLabel, 20);
        data.left = new FormAttachment(0, 10);
        this.indexingCheck.setLayoutData(data);
        this.indexingLabel = new Label(this, 0);
        this.indexingLabel.setText("The application will monitor the following folders:");
        data = new FormData();
        data.top = new FormAttachment(this.indexingCheck, 25);
        data.left = new FormAttachment(0, 10);
        this.indexingLabel.setLayoutData(data);
        this.addFolderBtn = new Button(this, 8);
        this.addFolderBtn.setText("Add");
        data = new FormData();
        data.top = new FormAttachment(this.indexingLabel, 0, 0x1000000);
        data.right = new FormAttachment(100, -10);
        this.addFolderBtn.setLayoutData(data);
        this.removeFolderBtn = new Button(this, 8);
        this.removeFolderBtn.setText("Remove");
        this.removeFolderBtn.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment(this.indexingLabel, 0, 0x1000000);
        data.right = new FormAttachment(this.addFolderBtn, 0);
        this.removeFolderBtn.setLayoutData(data);
        this.indexingFolders = new List(this, 2560);
        for (String s : settings.getIndexedFolders()) {
            this.indexingFolders.add(s);
        }
        data = new FormData();
        data.top = new FormAttachment(this.indexingLabel, 10);
        data.left = new FormAttachment(0, 10);
        data.height = 150;
        data.right = new FormAttachment(100, -10);
        this.indexingFolders.setLayoutData(data);
        Label dbLabel = new Label(this, 0);
        dbLabel.setText("Document database file location:");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(this.indexingFolders, 50);
        dbLabel.setLayoutData(data);
        this.browseBtn = new Button(this, 0);
        this.browseBtn.setText("Browse");
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(dbLabel, 5);
        this.browseBtn.setLayoutData(data);
        this.dbText = new Text(this, 2048);
        this.dbText.setEditable(false);
        this.dbText.setText(settings.getDatabaseFileLocation());
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(this.browseBtn, 0, 0x1000000);
        data.right = new FormAttachment(this.browseBtn, -5);
        this.dbText.setLayoutData(data);
        this.createEventHandlers();
    }

    private void createEventHandlers() {
        this.indexingCheck.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    SettingsData settings = SettingsManager.getCurrentSettings();
                    settings.setIndexingEnabled(SettingsPanel.this.indexingCheck.getSelection());
                    SettingsManager.storeSettings(settings);
                }
                catch (Exception ex) {
                    SettingsPanel.this.indexingCheck.setSelection(false);
                    NotificationWindow.showError("Error", "Failed to modify application settings.");
                }
                if (SettingsPanel.this.indexingCheck.getSelection()) {
                    SettingsPanel.this.setIndexing(true);
                } else {
                    SettingsPanel.this.setIndexing(false);
                }
            }
        });
        this.browseBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DirectoryDialog dd = new DirectoryDialog(SettingsPanel.this.getShell());
                dd.setText("Select database file location...");
                dd.setFilterPath(SettingsPanel.this.dbText.getText());
                String loc = dd.open();
                if (loc != null) {
                    String oldLoc = SettingsPanel.this.dbText.getText();
                    SettingsPanel.this.dbText.setText(loc);
                    try {
                        SettingsData settings = SettingsManager.getCurrentSettings();
                        settings.setDatabaseFileLocation(loc);
                        SettingsManager.storeSettings(settings);
                    }
                    catch (Exception e1) {
                        SettingsPanel.this.dbText.setText(oldLoc);
                        NotificationWindow.showError("Error", "Failed to modify application settings.");
                    }
                }
            }
        });
        this.indexingFolders.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (SettingsPanel.this.indexingFolders.getSelectionCount() == 0) {
                    SettingsPanel.this.removeFolderBtn.setEnabled(false);
                } else {
                    SettingsPanel.this.removeFolderBtn.setEnabled(true);
                }
            }
        });
        this.addFolderBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DirectoryDialog dd = new DirectoryDialog(SettingsPanel.this.getShell());
                dd.setText("Select a folder to monitor");
                String loc = dd.open();
                if (loc != null) {
                    SettingsPanel.this.addFolder(loc);
                }
            }
        });
        this.removeFolderBtn.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String[] selection = SettingsPanel.this.indexingFolders.getSelection();
                int i = 0;
                while (i < selection.length) {
                    SettingsPanel.this.removeFolder(selection[i]);
                    ++i;
                }
                SettingsPanel.this.removeFolderBtn.setEnabled(false);
                SettingsPanel.this.indexingFolders.setSelection(-1);
            }
        });
    }

    private void setIndexing(boolean enabled) {
        if (enabled) {
            AutomaticIndexing.enableAutomaticIndexing();
        } else {
            AutomaticIndexing.disableAutomaticIndexing();
        }
    }

    private void addFolder(String path) {
        try {
            SettingsData data = SettingsManager.getCurrentSettings();
            if (!data.getIndexedFolders().contains(path)) {
                this.indexingFolders.add(path);
                data.getIndexedFolders().add(path);
            }
            SettingsManager.storeSettings(data);
            AutomaticIndexing.getIndexers().addIndexer(IndexerFactory.getIndexing(path, data.getComputerId(), Application.getBll()));
        }
        catch (Exception e) {
            NotificationWindow.showError("Error", "Failed to modify application settings.");
        }
    }

    private void removeFolder(String path) {
        try {
            SettingsData data = SettingsManager.getCurrentSettings();
            if (data.getIndexedFolders().contains(path)) {
                data.getIndexedFolders().remove(path);
            }
            SettingsManager.storeSettings(data);
            this.indexingFolders.remove(path);
            AutomaticIndexing.getIndexers().removeIndexer(path, data.getComputerId());
        }
        catch (Exception e) {
            NotificationWindow.showError("Error", "Failed to modify application settings.");
        }
    }
}

