/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.indexing;

import hu.documaison.indexing.IndexerCollection;
import hu.documaison.settings.SettingsManager;
import java.util.Timer;
import java.util.TimerTask;

public class AutomaticIndexing {
    private static IndexerCollection indexers;
    private static Timer timer;
    private static TimerTask task;

    public static void setIndexers(IndexerCollection ic) {
        indexers = ic;
    }

    public static IndexerCollection getIndexers() {
        return indexers;
    }

    public static void enableAutomaticIndexing() {
        timer = new Timer(true);
        task = new TimerTask(){

            @Override
            public void run() {
                indexers.refreshAll();
            }
        };
        timer.schedule(task, 300000L, 300000L);
    }

    public static void disableAutomaticIndexing() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public static void initialize() {
        try {
            if (SettingsManager.getCurrentSettings().isIndexingEnabled()) {
                AutomaticIndexing.enableAutomaticIndexing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

