/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.indexing;

import hu.documaison.indexing.IndexerInterface;
import hu.documaison.indexing.interceptor.IndexerInterceptorDispatcher;
import java.util.ArrayList;
import java.util.Collection;

public class IndexerCollection {
    private Collection<IndexerInterface> indexers = new ArrayList<IndexerInterface>();
    private IndexerInterceptorDispatcher dispatcher = new IndexerInterceptorDispatcher();

    public void addIndexer(IndexerInterface indexer) {
        this.indexers.add(indexer);
        indexer.setDispatcher(this.dispatcher);
    }

    public IndexerInterceptorDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void refreshAll() {
        for (IndexerInterface indexer : this.indexers) {
            indexer.refresh();
        }
    }

    public void removeIndexer(String path, String computerId) {
        IndexerInterface toRemove = null;
        for (IndexerInterface i : this.indexers) {
            if (!i.getComputerId().equals(computerId) || !i.getIndexingPath().equals(path)) continue;
            toRemove = i;
            break;
        }
        this.indexers.remove(toRemove);
    }
}

