/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.indexing;

import hu.documaison.bll.interfaces.BllInterface;
import hu.documaison.data.exceptions.InvalidFolderException;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.SettingsAccessException;
import hu.documaison.indexing.IndexerCollection;
import hu.documaison.indexing.IndexerImpl;
import hu.documaison.indexing.IndexerInterface;
import hu.documaison.settings.SettingsData;
import hu.documaison.settings.SettingsManager;

public class IndexerFactory {
    public static IndexerInterface getIndexing(String folderPath, String currentComputerId, BllInterface bll) throws InvalidFolderException, InvalidParameterException {
        IndexerImpl impl = new IndexerImpl(folderPath, currentComputerId, bll);
        return impl;
    }

    public static IndexerCollection getAllIndexers(BllInterface bll) throws SettingsAccessException, InvalidFolderException, InvalidParameterException {
        SettingsData settings;
        try {
            settings = SettingsManager.getCurrentSettings();
        }
        catch (Exception e) {
            throw new SettingsAccessException();
        }
        String computerId = settings != null ? settings.getComputerId() : "";
        IndexerCollection indexerColl = new IndexerCollection();
        for (String folder : settings.getIndexedFolders()) {
            indexerColl.addIndexer(IndexerFactory.getIndexing(folder, computerId, bll));
        }
        return indexerColl;
    }
}

