/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.indexing;

import hu.documaison.bll.interfaces.BllInterface;
import hu.documaison.data.entities.Document;
import hu.documaison.data.entities.DocumentType;
import hu.documaison.data.entities.Metadata;
import hu.documaison.data.exceptions.InvalidFolderException;
import hu.documaison.data.exceptions.InvalidParameterException;
import hu.documaison.data.exceptions.UnknownDocumentException;
import hu.documaison.data.helper.DocumentFilePointer;
import hu.documaison.data.helper.FileHelper;
import hu.documaison.indexing.IndexerInterface;
import hu.documaison.indexing.interceptor.IndexerInterceptor;
import hu.documaison.indexing.interceptor.IndexerInterceptorDispatcher;
import java.io.File;
import java.util.Collection;
import java.util.Date;

class IndexerImpl
implements IndexerInterface {
    private BllInterface bll = null;
    private String folder;
    private String currentComputerId;
    private Collection<DocumentFilePointer> lastPointers = null;
    private IndexerInterceptorDispatcher dispatcher = null;

    public IndexerImpl(String folder, String currentComputerId, BllInterface bll) throws InvalidParameterException {
        this.setFolder(folder);
        this.setCurrentComputerId(currentComputerId);
        this.setBll(bll);
    }

    private void setCurrentComputerId(String currentComputerId) throws InvalidParameterException {
        if (currentComputerId == null) {
            throw new InvalidParameterException("currentComputerId");
        }
        this.currentComputerId = currentComputerId;
    }

    private void setFolder(String folder) throws InvalidFolderException {
        File folderFile = new File(folder);
        if (!folderFile.exists() || !folderFile.isDirectory()) {
            throw new InvalidFolderException(folder);
        }
        this.folder = folder;
    }

    private void setBll(BllInterface bll) throws InvalidParameterException {
        if (bll == null) {
            throw new InvalidParameterException("bll");
        }
        this.bll = bll;
    }

    @Override
    public void refresh() {
        this.lastPointers = this.bll.getDocumentPointers(String.valueOf(this.folder) + "%");
        for (DocumentFilePointer dfp : this.lastPointers) {
            File f = new File(dfp.getLocation());
            if (f.exists()) continue;
            this.onDeleted(dfp.getDocumentId());
        }
        this.recursiveRefresh(this.folder);
    }

    private void recursiveRefresh(String rootDirPath) {
        File[] fileList;
        System.out.println("Indexing directory: " + rootDirPath);
        File rootDir = new File(rootDirPath);
        File[] fileArray = fileList = rootDir.listFiles();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.recursiveRefresh(f.getAbsolutePath());
            } else if (f.isFile()) {
                this.fileRefresh(f);
            } else {
                System.err.println("H\u00e1t te ki vagy \u00e9s mit eszel?");
            }
            ++n2;
        }
    }

    private void fileRefresh(File file) {
        System.out.println("File found: " + file.getAbsolutePath());
        if (!this.inPointerList(file.getAbsolutePath())) {
            this.onAdded(file);
        } else {
            System.out.println(String.valueOf(file.getAbsolutePath()) + " is already in database.");
        }
    }

    private void onDeleted(int documentId) {
        Document document;
        System.err.println("REMOVE: id = " + documentId);
        try {
            document = this.bll.getDocument(documentId);
        }
        catch (UnknownDocumentException e) {
            return;
        }
        if (document == null) {
            return;
        }
        if (!document.getCreatorComputerId().equalsIgnoreCase(this.currentComputerId)) {
            return;
        }
        if (this.dispatcher != null && this.dispatcher.getInterceptors() != null) {
            for (IndexerInterceptor interceptor : this.dispatcher.getInterceptors()) {
                interceptor.beforeDocumentDeleted(document);
            }
        }
        this.bll.removeDocument(documentId);
        if (this.dispatcher != null && this.dispatcher.getInterceptors() != null) {
            for (IndexerInterceptor interceptor : this.dispatcher.getInterceptors()) {
                interceptor.onDocumentDeleted(documentId);
            }
        }
    }

    private void onAdded(File file) {
        Document newDoc;
        if (this.dispatcher != null && this.dispatcher.getInterceptors() != null) {
            for (IndexerInterceptor interceptor : this.dispatcher.getInterceptors()) {
                interceptor.beforeDocumentAdded(file.toString());
            }
        }
        System.err.println("ADD: path = " + file);
        String extension = FileHelper.fileExtension(file.getAbsolutePath());
        DocumentType dt = this.bll.getDocumentTypeForExtension(extension);
        if (dt == null) {
            this.onAddingError(file, "DocumentType not found for extension: " + extension);
            return;
        }
        System.err.println("Found type for " + extension + " ext: " + dt.getTypeName());
        try {
            newDoc = this.bll.createDocument(dt.getId());
            newDoc.setLocation(file.toString());
            newDoc.setCreatorComputerId(this.currentComputerId);
            newDoc.setDateAdded(new Date());
            this.bll.updateDocument(newDoc);
            Metadata md1 = this.bll.createMetadata(newDoc);
            md1.setName("autocreated");
            md1.setValue("true");
            this.bll.updateMetadata(md1);
        }
        catch (Exception e) {
            this.onAddingError(file, null);
            return;
        }
        if (this.dispatcher != null && this.dispatcher.getInterceptors() != null) {
            for (IndexerInterceptor interceptor : this.dispatcher.getInterceptors()) {
                interceptor.onDocumentAdded(newDoc);
            }
        }
    }

    private void onAddingError(File file, String message) {
        if (message == null) {
            message = "N/A";
        }
        System.err.println("Adding error: " + message + " @ " + file.toString());
        if (this.dispatcher != null && this.dispatcher.getInterceptors() != null) {
            for (IndexerInterceptor interceptor : this.dispatcher.getInterceptors()) {
                interceptor.onDocumentAddingError(file.toString());
            }
        }
    }

    private boolean inPointerList(String absolutePath) {
        for (DocumentFilePointer dfp : this.lastPointers) {
            if (dfp.getLocation() == null || !dfp.getFile().getAbsolutePath().equals(absolutePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDispatcher(IndexerInterceptorDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public String getIndexingPath() {
        return this.folder;
    }

    @Override
    public String getComputerId() {
        return this.currentComputerId;
    }
}

