/*
 * Decompiled with CFR 0.152.
 */
package hu.documaison.settings;

import hu.documaison.settings.SettingsData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SettingsManager {
    private static final String SETTINGS_XML = "settings.xml";

    public static SettingsData getCurrentSettings() throws Exception {
        try {
            JAXBContext context = JAXBContext.newInstance(SettingsData.class);
            Unmarshaller um = context.createUnmarshaller();
            return (SettingsData)um.unmarshal(new FileReader(SETTINGS_XML));
        }
        catch (Exception e) {
            return SettingsManager.createDefaultSettingsData();
        }
    }

    private static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown_computer";
        }
    }

    private static SettingsData createDefaultSettingsData() throws Exception {
        SettingsData data = new SettingsData();
        data.setEvernoteIndexingEnabled(false);
        data.setIndexingEnabled(false);
        String currentDir = new File(".").getCanonicalPath();
        data.setDatabaseFileLocation(String.valueOf(currentDir) + System.getProperty("file.separator") + "documaison.db");
        data.setComputerId(String.valueOf(System.getProperty("user.name", "user")) + "@" + SettingsManager.getComputerName());
        SettingsManager.storeSettings(data);
        return data;
    }

    public static void storeSettings(SettingsData data) throws Exception {
        JAXBContext context = JAXBContext.newInstance(SettingsData.class);
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        Writer w = null;
        try {
            w = new FileWriter(SETTINGS_XML);
            m.marshal((Object)data, w);
        }
        finally {
            w.close();
        }
    }
}

